/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import cn.xfyun.model.sign.AbstractSignature;
import cn.xfyun.util.CryptTools;
import cn.xfyun.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Hmac256Signature
extends AbstractSignature {
    public Hmac256Signature(String apiKey, String secretKey, String hostUrl) {
        super(apiKey, secretKey, hostUrl);
    }

    public Hmac256Signature(String apiKey, String secretKey, String hostUrl, boolean isPost) {
        super(apiKey, secretKey, hostUrl, isPost);
    }

    @Override
    public String getSigna() throws SignatureException {
        if (StringUtils.isNullOrEmpty(this.signa)) {
            String originSign = this.generateOriginSign();
            this.setOriginSign(originSign);
            this.signa = this.generateSignature();
        }
        return this.signa;
    }

    @Override
    public String generateTs() {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = format.format(new Date());
        return date;
    }

    public String generateSignature() throws SignatureException {
        return CryptTools.hmacEncrypt("HmacSHA256", this.getOriginSign(), this.getKey());
    }

    @Override
    public String generateOriginSign() throws SignatureException {
        try {
            URL url = new URL(this.getUrl());
            return "host: " + url.getHost() + "\ndate: " + this.getTs() + "\n" + this.requestMethod + " " + url.getPath() + " HTTP/1.1";
        }
        catch (MalformedURLException e) {
            throw new SignatureException("MalformedURLException:" + e.getMessage());
        }
    }
}

