/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import cn.xfyun.util.CryptTools;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoiceCloneSignature {
    private static final Logger logger = LoggerFactory.getLogger(VoiceCloneSignature.class);

    public static Map<String, String> tokenSign(String apiKey, String timestamp, String body) {
        try {
            HashMap<String, String> header = new HashMap<String, String>(6);
            String builder = CryptTools.md5Encrypt(apiKey + timestamp) + body;
            String authorization = CryptTools.md5Encrypt(builder);
            header.put("Authorization", authorization);
            header.put("Content-Type", "application/json");
            return header;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210token\u5934\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> commonSign(String appId, String apiKey, String body, String token) {
        try {
            String timestamp = String.valueOf(System.currentTimeMillis());
            String builder = apiKey + timestamp + CryptTools.md5Encrypt(body);
            String authorization = CryptTools.md5Encrypt(builder);
            HashMap<String, String> header = new HashMap<String, String>(6);
            header.put("X-Sign", authorization);
            header.put("X-Token", token);
            header.put("X-AppId", appId);
            header.put("X-Time", timestamp);
            return header;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u901a\u7528\u52a0\u5bc6\u5934\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

