/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.api;

import cn.xfyun.base.http.HttpBuilder;
import cn.xfyun.base.http.HttpClient;
import cn.xfyun.config.SparkBatchEnum;
import cn.xfyun.exception.BusinessException;
import cn.xfyun.util.StringUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkBatchClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(SparkBatchClient.class);

    public SparkBatchClient(Builder builder) {
        super((HttpBuilder)builder);
    }

    public String upload(File file) throws IOException {
        this.uploadCheck(file);
        RequestBody body = this.getFormDataBody(file);
        return this.send(SparkBatchEnum.UPLOAD_FILE, body, new Object[0]);
    }

    public String listFile(int pageNum, int pageSize) throws IOException {
        return this.send(SparkBatchEnum.GET_FILES, null, pageNum, pageSize);
    }

    public String getFile(String fileId) throws IOException {
        this.nullCheck(fileId);
        return this.send(SparkBatchEnum.GET_FILE, null, fileId);
    }

    public String deleteFile(String fileId) throws IOException {
        this.nullCheck(fileId);
        return this.send(SparkBatchEnum.DELETE_FILE, null, fileId);
    }

    public String download(String fileId) throws IOException {
        this.nullCheck(fileId);
        return this.send(SparkBatchEnum.DOWNLOAD_FILE, null, fileId);
    }

    public String create(String fileId, Map<String, String> metadata) throws IOException {
        this.nullCheck(fileId);
        RequestBody body = this.getCreateParam(fileId, metadata);
        return this.send(SparkBatchEnum.CREATE, body, fileId);
    }

    public String getBatch(String batchId) throws IOException {
        this.nullCheck(batchId);
        return this.send(SparkBatchEnum.GET_BATCH, null, batchId);
    }

    public String cancel(String batchId) throws IOException {
        this.nullCheck(batchId);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)"{}");
        return this.send(SparkBatchEnum.CANCEL, body, batchId);
    }

    public String listBatch(int limit, String batchId) throws IOException {
        return this.send(SparkBatchEnum.GET_BATCHES, null, limit, batchId);
    }

    private String send(SparkBatchEnum batchEnum, RequestBody body, Object ... param) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + this.apiKey);
        String url = batchEnum.getUrl();
        if (param != null) {
            url = String.format(batchEnum.getUrl(), param);
        }
        logger.debug("{}\u8bf7\u6c42URL\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{batchEnum.getDesc(), url, null == body ? "" : body.toString()});
        return this.sendRequest(url, batchEnum.getMethod(), header, body);
    }

    private void uploadCheck(File file) {
        if (null == file || !file.exists() || file.length() == 0L) {
            throw new BusinessException("\u65e0\u6548\u7684jsonl\u6587\u4ef6");
        }
        if (!file.getName().endsWith(".jsonl")) {
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u7684\u6587\u4ef6");
        }
    }

    private void nullCheck(String fileId) {
        if (StringUtils.isNullOrEmpty((String)fileId)) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private RequestBody getFormDataBody(File file) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file));
        builder.addFormDataPart("purpose", "batch");
        return builder.build();
    }

    private RequestBody getCreateParam(String fileId, Map<String, String> metadata) {
        JsonObject obj = new JsonObject();
        obj.addProperty("input_file_id", fileId);
        obj.addProperty("endpoint", "/v1/chat/completions");
        obj.addProperty("completion_window", "24h");
        if (null != metadata) {
            obj.add("metadata", StringUtils.gson.toJsonTree(metadata));
        }
        return RequestBody.create((MediaType)JSON, (String)obj.toString());
    }

    public static final class Builder
    extends HttpBuilder<Builder> {
        private static final String HOST_URL = "https://spark-api-open.xf-yun.com/";

        public Builder(String appId, String apiPassword) {
            super(HOST_URL, appId, apiPassword, null);
        }

        public SparkBatchClient build() {
            return new SparkBatchClient(this);
        }
    }
}

