/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sparkmodel.request;

import cn.xfyun.exception.BusinessException;
import cn.xfyun.util.StringUtils;
import java.io.File;

public class KnowledgeFileUpload {
    private File file;
    private String knowledgeName;
    private String purpose;

    public KnowledgeFileUpload(Builder builder) {
        this.file = builder.file;
        this.knowledgeName = builder.knowledgeName;
        this.purpose = builder.purpose;
    }

    public KnowledgeFileUpload() {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getKnowledgeName() {
        return this.knowledgeName;
    }

    public void setKnowledgeName(String knowledgeName) {
        this.knowledgeName = knowledgeName;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void selfCheck() {
        if (StringUtils.isNullOrEmpty((String)this.knowledgeName)) {
            throw new BusinessException("\u77e5\u8bc6\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.purpose) {
            throw new BusinessException("purpose\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.file) {
            throw new BusinessException("\u5a92\u4f53\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private File file;
        private String knowledgeName;
        private String purpose = "file-extract";

        private Builder() {
        }

        public KnowledgeFileUpload build() {
            return new KnowledgeFileUpload(this);
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder knowledgeName(String knowledgeName) {
            this.knowledgeName = knowledgeName;
            return this;
        }

        public Builder purpose(String purpose) {
            this.purpose = purpose;
            return this;
        }
    }
}

