/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.voiceclone.request;

import cn.xfyun.exception.BusinessException;
import cn.xfyun.util.StringUtils;
import java.io.File;

public class AudioAddParam {
    private String taskId;
    private File file;
    private String audioUrl;
    private Long textId;
    private Long textSegId;
    private Integer denoiseSwitch;
    private Float mosRatio;

    public AudioAddParam(Builder builder) {
        this.taskId = builder.taskId;
        this.textId = builder.textId;
        this.textSegId = builder.textSegId;
        this.audioUrl = builder.audioUrl;
        this.file = builder.file;
        this.denoiseSwitch = builder.denoiseSwitch;
        this.mosRatio = builder.mosRatio;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getAudioUrl() {
        return this.audioUrl;
    }

    public void setAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
    }

    public Long getTextId() {
        return this.textId;
    }

    public void setTextId(Long textId) {
        this.textId = textId;
    }

    public Long getTextSegId() {
        return this.textSegId;
    }

    public void setTextSegId(Long textSegId) {
        this.textSegId = textSegId;
    }

    public Integer getDenoiseSwitch() {
        return this.denoiseSwitch;
    }

    public void setDenoiseSwitch(Integer denoiseSwitch) {
        this.denoiseSwitch = denoiseSwitch;
    }

    public Float getMosRatio() {
        return this.mosRatio;
    }

    public void setMosRatio(Float mosRatio) {
        this.mosRatio = mosRatio;
    }

    public String toJsonString() {
        return StringUtils.gson.toJson((Object)this);
    }

    public void selfCheckFile() {
        if (StringUtils.isNullOrEmpty((String)this.taskId)) {
            throw new BusinessException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.file) {
            throw new BusinessException("\u5a92\u4f53\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.textId) {
            throw new BusinessException("\u6587\u672cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.textSegId) {
            throw new BusinessException("\u6587\u672c\u6bb5\u843dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void selfCheckUrl() {
        if (StringUtils.isNullOrEmpty((String)this.taskId)) {
            throw new BusinessException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.audioUrl) {
            throw new BusinessException("\u5a92\u4f53\u6587\u4ef6url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.textId) {
            throw new BusinessException("\u6587\u672cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == this.textSegId) {
            throw new BusinessException("\u6587\u672c\u6bb5\u843dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String taskId;
        private Long textId;
        private Long textSegId;
        private String audioUrl;
        private File file;
        private Integer denoiseSwitch;
        private Float mosRatio;

        public AudioAddParam build() {
            return new AudioAddParam(this);
        }

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        public Builder textId(Long textId) {
            this.textId = textId;
            return this;
        }

        public Builder textSegId(Long textSegId) {
            this.textSegId = textSegId;
            return this;
        }

        public Builder mosRatio(float mosRatio) {
            this.mosRatio = Float.valueOf(mosRatio);
            return this;
        }

        public Builder denoiseSwitch(int denoiseSwitch) {
            this.denoiseSwitch = denoiseSwitch;
            return this;
        }
    }
}

