/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.agent;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentCallback
implements Callback {
    private static final Logger logger = LoggerFactory.getLogger(AgentCallback.class);

    public abstract void onEvent(Call var1, String var2, String var3, String var4);

    public abstract void onFail(Call var1, Throwable var2);

    public abstract void onClosed(Call var1);

    public abstract void onOpen(Call var1, Response var2);

    public void onFailure(Call call, IOException e) {
        this.onFail(call, e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.onOpen(call, response);
        if (!response.isSuccessful()) {
            logger.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u539f\u56e0\uff1a{}", (Object)response.code(), (Object)response.message());
            return;
        }
        ResponseBody body = response.body();
        if (null != body) {
            String id = null;
            String type = "message";
            BufferedSource source = body.source();
            while (!source.exhausted() && !call.isCanceled()) {
                String line = source.readUtf8LineStrict();
                if (line.isEmpty()) {
                    type = "message";
                    id = null;
                    continue;
                }
                if (line.startsWith("id:")) {
                    id = line.substring(3).trim();
                    continue;
                }
                if (line.startsWith("event:")) {
                    type = line.substring(6).trim();
                    continue;
                }
                if (!line.startsWith("data:")) continue;
                String data = line.substring(5).trim();
                this.onEvent(call, id, type, data);
            }
        }
        response.close();
        this.onClosed(call);
    }
}

