/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.service.sparkiat;

import cn.xfyun.api.SparkIatClient;
import cn.xfyun.model.sparkiat.request.SparkIatRequest;
import cn.xfyun.service.common.AbstractTask;
import cn.xfyun.util.StringUtils;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIatSendTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger(SparkIatSendTask.class);
    private static final int STATUS_FIRST_FRAME = 0;
    private static final int STATUS_CONTINUED_FRAME = 1;
    private static final int STATUS_LAST_FRAME = 2;
    private int status = 0;
    private SparkIatClient sparkIatClient = null;

    @Override
    public String businessDataProcess(byte[] contents, boolean isEnd, Integer seq) {
        if (isEnd) {
            this.status = 2;
        }
        SparkIatRequest request = new SparkIatRequest();
        SparkIatRequest.Header header = new SparkIatRequest.Header(this.client().getAppId(), this.status);
        request.setHeader(header);
        switch (this.status) {
            case 0: {
                SparkIatRequest.Parameter parameter = new SparkIatRequest.Parameter(this.client());
                request.setParameter(parameter);
                SparkIatRequest.Payload firstPayload = new SparkIatRequest.Payload(this.client());
                firstPayload.getAudio().setAudio(Base64.getEncoder().encodeToString(contents));
                firstPayload.getAudio().setSeq(seq);
                firstPayload.getAudio().setStatus(0);
                request.setPayload(firstPayload);
                this.status = 1;
                String first = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u7b2c\u4e00\u5e27\u6570\u636e\uff1a{}", (Object)first);
                return first;
            }
            case 1: {
                SparkIatRequest.Payload continuedPayload = new SparkIatRequest.Payload(this.client());
                continuedPayload.getAudio().setAudio(Base64.getEncoder().encodeToString(contents));
                continuedPayload.getAudio().setSeq(seq);
                continuedPayload.getAudio().setStatus(1);
                request.setPayload(continuedPayload);
                String continued = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u4e2d\u95f4\u5e27\u6570\u636e\uff1a{}", (Object)continued);
                return continued;
            }
            case 2: {
                SparkIatRequest.Payload lastPayload = new SparkIatRequest.Payload(this.client());
                lastPayload.getAudio().setAudio("");
                lastPayload.getAudio().setSeq(seq);
                lastPayload.getAudio().setStatus(2);
                request.setPayload(lastPayload);
                String last = StringUtils.gson.toJson((Object)request);
                logger.debug("\u53d1\u9001\u6700\u540e\u4e00\u5e27\u6570\u636e\uff1a{}", (Object)last);
                return last;
            }
        }
        return null;
    }

    private SparkIatClient client() {
        if (this.sparkIatClient == null) {
            this.sparkIatClient = (SparkIatClient)this.client;
            return this.sparkIatClient;
        }
        return this.sparkIatClient;
    }
}

