/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.impl.visitor;

import com.alibaba.citrus.dev.handler.impl.ExplorerHandler;
import com.alibaba.citrus.dev.handler.impl.visitor.AbstractFallbackVisitor;
import com.alibaba.citrus.dev.handler.util.ReflectionUtil;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ResolvableDepsVisitor
extends AbstractFallbackVisitor<ExplorerHandler.ExplorerVisitor> {
    private final Map<Class<?>, Object> resolvableDependencies = this.getResolvableDependencies((DefaultListableBeanFactory)((ExplorerHandler.ExplorerVisitor)this.getFallbackVisitor()).getApplicationContext().getBeanFactory());
    private Class<?> type;
    private Object value;
    private int id = 1000;

    public ResolvableDepsVisitor(RequestHandlerContext context, ExplorerHandler.ExplorerVisitor v) {
        super(context, v);
    }

    private Map<Class<?>, Object> getResolvableDependencies(DefaultListableBeanFactory factory) {
        Map<Class<Object>, Object> deps;
        try {
            deps = (Map)ReflectionUtil.getAccessibleField(factory.getClass(), "resolvableDependencies").get(factory);
        }
        catch (Exception e) {
            deps = CollectionUtil.createHashMap();
        }
        return deps;
    }

    public void visitResolvableDependencyCount() {
        ((PrintWriter)this.out()).print(this.resolvableDependencies.size());
    }

    public void visitResolvableDependency(Template resolvableDependencyTemplate) {
        TreeMap<Class<?>, Object> sorted = CollectionUtil.createTreeMap(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                int n2;
                int n1 = StringUtil.countMatches(o1.getName(), ".");
                if (n1 != (n2 = StringUtil.countMatches(o2.getName(), "."))) {
                    return n1 - n2;
                }
                if (!o1.getPackage().getName().equals(o2.getPackage().getName())) {
                    return o1.getPackage().getName().compareTo(o2.getPackage().getName());
                }
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        sorted.putAll(this.resolvableDependencies);
        for (Map.Entry entry : sorted.entrySet()) {
            this.type = (Class)entry.getKey();
            this.value = entry.getValue();
            ++this.id;
            resolvableDependencyTemplate.accept(this);
        }
    }

    public void visitTypePackage() {
        if (this.type.getPackage() != null) {
            ((PrintWriter)this.out()).print(this.type.getPackage().getName() + ".");
        }
    }

    public void visitTypeName() {
        ((PrintWriter)this.out()).print(ClassUtil.getSimpleClassName(this.type));
    }

    public void visitVarName() {
        ((PrintWriter)this.out()).print(StringUtil.toCamelCase(this.type.getSimpleName()));
    }

    public void visitValueTypePackage() {
        if (this.value != null && this.value.getClass().getPackage() != null) {
            ((PrintWriter)this.out()).print(this.value.getClass().getPackage().getName() + ".");
        }
    }

    public void visitValueTypeName() {
        if (this.value != null) {
            ((PrintWriter)this.out()).print(ClassUtil.getSimpleClassName(this.value.getClass(), false));
        }
    }

    public void visitValueId() {
        ((PrintWriter)this.out()).print(this.id);
    }

    public void visitValue() {
        ((PrintWriter)this.out()).print(StringEscapeUtil.escapeHtml(String.valueOf(this.value)));
    }
}

