/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.dev.handler.util;

import com.alibaba.citrus.dev.handler.util.Attribute;
import com.alibaba.citrus.dev.handler.util.StyledValue;
import com.alibaba.citrus.dev.handler.util.TextValue;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class Element {
    private static final AtomicLong counter = new AtomicLong();
    private final String id;
    private final String name;
    private final String ns;
    final List<Element> subElements = CollectionUtil.createLinkedList();
    private final Map<String, Attribute> attrs = CollectionUtil.createArrayHashMap();
    private StyledValue text;

    public Element(String name) {
        this(name, null);
    }

    public Element(String name, String ns) {
        this.name = Assert.assertNotNull(StringUtil.trimToNull(name), "element name", new Object[0]);
        this.ns = StringUtil.trimToNull(ns);
        this.id = name + "-" + counter.addAndGet(1L);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        int index = this.name.indexOf(":");
        if (index >= 0) {
            return StringUtil.trimToNull(this.name.substring(0, index));
        }
        return null;
    }

    public String getLocalName() {
        int index = this.name.indexOf(":");
        if (index >= 0) {
            return this.name.substring(index + 1);
        }
        return this.name;
    }

    public String getNs() {
        return this.ns;
    }

    public Element addAttribute(String key, String value) {
        this.attrs.put(key, new Attribute(key, new TextValue(value)));
        return this;
    }

    public Element addAttribute(String key, StyledValue value) {
        this.attrs.put(key, new Attribute(key, value));
        return this;
    }

    public Element setText(String text) {
        return this.setText(new TextValue(text));
    }

    public Element setText(StyledValue text) {
        Assert.assertTrue(this.subElements.isEmpty(), "subElements is not empty", new Object[0]);
        this.text = text;
        return this;
    }

    public StyledValue getText() {
        return this.text;
    }

    public Element newSubElement(String name) {
        Element subElement = new Element(name);
        this.addSubElement(subElement);
        return subElement;
    }

    public void addSubElement(Element subElement) {
        Assert.assertNull(this.text, "text is not null", new Object[0]);
        if (subElement != null) {
            this.subElements.add(subElement);
        }
    }

    public boolean hasSubElements() {
        return !this.subElements.isEmpty();
    }

    public Iterable<Element> subElements() {
        return this.subElements;
    }

    public Iterable<Attribute> attributes() {
        return this.attrs.values();
    }

    public boolean hasAttribute(String key) {
        return this.attrs.get(key) != null;
    }

    public StyledValue getAttribute(String key) {
        if (this.hasAttribute(key)) {
            return this.attrs.get(key).getValue();
        }
        return null;
    }
}

