/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.FieldInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.MethodInfo;
import com.alibaba.citrus.generictype.ParameterizedTypeInfo;
import com.alibaba.citrus.generictype.RawTypeInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.TypeVariableInfo;
import com.alibaba.citrus.generictype.impl.TypeInfoFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.internal.LazyLoader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ParameterizedTypeImpl
implements ParameterizedTypeInfo {
    private final RawTypeInfo rawType;
    private final LazyLoader<Supertypes, Object> supertypesLoader;
    private List<TypeInfo> actualTypeArguments;
    private boolean resolved;

    ParameterizedTypeImpl(RawTypeInfo rawType) {
        Assert.assertTrue(rawType != null && ParameterizedTypeImpl.getTypeParameters(rawType).length > 0, "rawType", new Object[0]);
        this.rawType = rawType;
        this.supertypesLoader = LazyLoader.getDefault(new SupertypesLoader());
    }

    void init(TypeInfo[] actualTypeArguments) {
        int expectedParams;
        this.actualTypeArguments = Collections.unmodifiableList(CollectionUtil.asList(actualTypeArguments));
        int actualArgs = this.actualTypeArguments.size();
        Assert.assertTrue(actualArgs == (expectedParams = ParameterizedTypeImpl.getTypeParameters(this.rawType).length), "actual arguments length not match: expected %d, actual %d", expectedParams, actualArgs);
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            TypeVariable<?> var = ParameterizedTypeImpl.getTypeParameters(this.rawType)[i];
            Class<?> argClass = actualTypeArguments[i].getRawType();
            ParameterizedTypeImpl.checkBounds(var, null, argClass, false);
        }
    }

    private static TypeVariable<?>[] getTypeParameters(RawTypeInfo rawType) {
        return rawType.getRawType().getTypeParameters();
    }

    private static void checkBounds(TypeVariable<?> var, Type type, Class<?> argClass, boolean array) {
        if (type == null) {
            type = var;
        }
        if (type instanceof Class) {
            Class superclass = (Class)((Object)type);
            Assert.assertTrue(superclass.isAssignableFrom(argClass), array ? "actual argument of parameter %s should be array of sub-class of %s, but was array of %s" : "actual argument of parameter %s should be sub-class of %s, but was %s", var, superclass, argClass);
            return;
        }
        if (type instanceof TypeVariable) {
            for (Type ub : type.getBounds()) {
                ParameterizedTypeImpl.checkBounds(var, ub, argClass, false);
            }
            return;
        }
        if (type instanceof GenericArrayType) {
            Assert.assertTrue(argClass.isArray(), "actual argument of parameter %s should be array, but was %s", var, argClass);
            ParameterizedTypeImpl.checkBounds(var, ((GenericArrayType)((Object)type)).getGenericComponentType(), argClass.getComponentType(), true);
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedTypeImpl.checkBounds(var, ((ParameterizedType)((Object)type)).getRawType(), argClass, false);
            return;
        }
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType.getRawType();
    }

    @Override
    public String getName() {
        return this.rawType.getName();
    }

    @Override
    public String getSimpleName() {
        return this.rawType.getSimpleName();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return this.rawType.isInterface();
    }

    @Override
    public TypeInfo getPrimitiveWrapperType() {
        return this;
    }

    @Override
    public TypeInfo getComponentType() {
        return this;
    }

    @Override
    public TypeInfo getDirectComponentType() {
        return this;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public List<TypeVariableInfo> getTypeParameters() {
        return this.rawType.getTypeParameters();
    }

    @Override
    public List<TypeInfo> getInterfaces() {
        return this.supertypesLoader.getInstance().interfaces;
    }

    @Override
    public List<TypeInfo> getSuperclasses() {
        return this.supertypesLoader.getInstance().superclasses;
    }

    @Override
    public List<TypeInfo> getSupertypes() {
        return this.supertypesLoader.getInstance().supertypes;
    }

    @Override
    public TypeInfo getSupertype(Class<?> equivalentClass) {
        return TypeInfoFactory.findSupertype(this, equivalentClass);
    }

    @Override
    public ClassTypeInfo resolve(GenericDeclarationInfo context) {
        return this.resolve(context, true);
    }

    @Override
    public ClassTypeInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        ParameterizedTypeImpl result;
        if (this.resolved) {
            return this;
        }
        List<TypeVariableInfo> vars = this.getTypeParameters();
        List<TypeInfo> actualArgs = this.getActualTypeArguments();
        TypeInfo[] resolvedArgs = new TypeInfo[vars.size()];
        boolean resolved = true;
        boolean changed = false;
        for (int i = 0; i < resolvedArgs.length; ++i) {
            TypeInfo resolvedArg;
            TypeInfo arg = actualArgs.get(i);
            if (arg != (resolvedArg = arg.resolve(context, includeBaseType))) {
                changed = true;
            }
            if (resolvedArg instanceof ParameterizedTypeImpl) {
                resolved &= ((ParameterizedTypeImpl)resolvedArg).resolved;
            } else if (resolvedArg instanceof TypeVariableInfo) {
                resolved = false;
            }
            resolvedArgs[i] = resolvedArg;
        }
        ParameterizedTypeImpl parameterizedTypeImpl = result = changed ? (ParameterizedTypeImpl)factory.getParameterizedType((TypeInfo)this.rawType, resolvedArgs) : this;
        if (resolved) {
            result.resolved = resolved;
        }
        return result;
    }

    @Override
    public List<TypeInfo> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public TypeInfo getActualTypeArgument(String name) {
        List<TypeVariableInfo> vars = this.getTypeParameters();
        for (int i = 0; i < vars.size(); ++i) {
            if (!vars.get(i).getName().equals(name)) continue;
            return this.actualTypeArguments.get(i);
        }
        return null;
    }

    @Override
    public FieldInfo getField(String name) {
        return TypeInfoFactory.getField(this, this, name);
    }

    @Override
    public FieldInfo getField(ClassTypeInfo declaringType, String name) {
        return TypeInfoFactory.getField(this, declaringType, name);
    }

    @Override
    public MethodInfo getConstructor(Class<?> ... paramTypes) {
        return TypeInfoFactory.getConstructor(this, paramTypes);
    }

    @Override
    public MethodInfo getMethod(String methodName, Class<?> ... paramTypes) {
        return TypeInfoFactory.getMethod(this, methodName, paramTypes);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.rawType.hashCode() ^ ((Object)this.actualTypeArguments).hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        ParameterizedTypeImpl otherType = (ParameterizedTypeImpl)other;
        return this.rawType.equals(otherType.rawType) && ((Object)this.actualTypeArguments).equals(otherType.actualTypeArguments);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ClassUtil.getSimpleClassName(this.getRawType()));
        buf.append("<");
        for (int i = 0; i < this.actualTypeArguments.size(); ++i) {
            buf.append(this.rawType.getTypeParameters().get(i)).append("=").append(this.actualTypeArguments.get(i));
            if (i >= this.actualTypeArguments.size() - 1) continue;
            buf.append(", ");
        }
        buf.append(">");
        return buf.toString();
    }

    private class SupertypesLoader
    implements LazyLoader.Loader<Supertypes, Object> {
        private SupertypesLoader() {
        }

        @Override
        public Supertypes load(Object context) {
            return new Supertypes(ParameterizedTypeImpl.this);
        }
    }

    private static class Supertypes {
        private final List<TypeInfo> supertypes;
        private final List<TypeInfo> interfaces;
        private final List<TypeInfo> superclasses;

        private Supertypes(ParameterizedTypeImpl parameterizedType) {
            RawTypeInfo rawType = parameterizedType.rawType;
            List<TypeInfo> rawSupertypes = rawType.getSupertypes();
            List<TypeInfo> rawInterfaces = rawType.getInterfaces();
            List<TypeInfo> rawSuperclasses = rawType.getSuperclasses();
            ArrayList<TypeInfo> supertypes = CollectionUtil.createArrayList(rawSupertypes.size());
            ArrayList interfaces = CollectionUtil.createArrayList(rawInterfaces.size());
            ArrayList superclasses = CollectionUtil.createArrayList(rawSuperclasses.size());
            for (TypeInfo supertype : rawSupertypes) {
                if (supertype instanceof RawTypeInfo) {
                    if (supertype == rawType) {
                        supertypes.add(parameterizedType);
                        continue;
                    }
                    supertypes.add(supertype);
                    continue;
                }
                if (supertype instanceof ParameterizedTypeInfo) {
                    supertypes.add(supertype);
                    continue;
                }
                Assert.unreachableCode("Unexpected super type: %s", supertype);
            }
            for (TypeInfo supertype : supertypes) {
                if (supertype.getRawType().isInterface()) {
                    interfaces.add(supertype);
                    continue;
                }
                superclasses.add(supertype);
            }
            Assert.assertTrue(supertypes.size() == rawSupertypes.size(), "supertypes size", new Object[0]);
            Assert.assertTrue(interfaces.size() == rawInterfaces.size(), "interfaces size", new Object[0]);
            Assert.assertTrue(superclasses.size() == rawSuperclasses.size(), "superclasses size", new Object[0]);
            this.supertypes = Collections.unmodifiableList(supertypes);
            this.interfaces = Collections.unmodifiableList(interfaces);
            this.superclasses = Collections.unmodifiableList(superclasses);
        }
    }
}

