/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

final class FormParameters {
    private final Map<String, FormParameter> params = CollectionUtil.createLinkedHashMap();
    private final HttpServletRequest request;
    private final ParserRequestContext prc;

    public FormParameters(HttpServletRequest request) {
        this.request = request;
        this.prc = RequestContextUtil.findRequestContext(request, ParserRequestContext.class);
    }

    public void addFormParameter(FormParameter param) {
        this.params.put(param.normalizedKey, param);
    }

    public FormParameter getFormParameter(String normalizedKey) {
        return this.params.get(normalizedKey);
    }

    public Object[] getValues(String normalizedKey) {
        FormParameter param = this.params.get(normalizedKey);
        if (param == null) {
            return null;
        }
        if (this.prc != null) {
            return this.prc.getParameters().getObjects(param.originalKey);
        }
        return this.request.getParameterValues(param.originalKey);
    }

    public String getStringValue(String normalizedKey) {
        FormParameter param = this.params.get(normalizedKey);
        if (param == null) {
            return null;
        }
        if (this.prc != null) {
            return this.prc.getParameters().getString(param.originalKey);
        }
        return this.request.getParameter(param.originalKey);
    }

    public String toString() {
        return new ToStringBuilder().append("FormParameters").append(this.params.values()).toString();
    }

    static final class FormParameter {
        public final String groupKey;
        public final String fieldKey;
        public final String instanceKey;
        public final String additionalInfo;
        public final String originalKey;
        public final String normalizedKey;

        FormParameter(String groupKey, String fieldKey, String instanceKey, String additionalInfo, String originalKey, String normalizedKey) {
            this.groupKey = groupKey;
            this.fieldKey = fieldKey;
            this.instanceKey = instanceKey;
            this.additionalInfo = additionalInfo;
            this.originalKey = originalKey;
            this.normalizedKey = normalizedKey;
        }

        public String toString() {
            return this.normalizedKey;
        }
    }
}

