/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.adapter;

import com.alibaba.citrus.service.moduleloader.Module;
import com.alibaba.citrus.service.moduleloader.ModuleInfo;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.impl.adapter.AbstractDataBindingAdapterFactory;
import com.alibaba.citrus.service.moduleloader.impl.adapter.ActionEventAdapter;
import com.alibaba.citrus.service.moduleloader.impl.adapter.MethodInvoker;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ActionEventAdapterFactory
extends AbstractDataBindingAdapterFactory
implements ApplicationContextAware {
    private static final String DEFAULT_EVENT = "perform";
    private static final String PRE_HANDLER = "beforeExecution";
    private static final String POST_HANDLER = "afterExecution";
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public Module adapt(String type, String name, Object moduleObject) {
        if (!"action".equalsIgnoreCase(type)) {
            return null;
        }
        Class<?> moduleClass = moduleObject.getClass();
        Map<String, Method> handlers = this.getEventHandlers(moduleClass);
        if (handlers == null) {
            return null;
        }
        ModuleInfo moduleInfo = new ModuleInfo(type, name);
        FastClass fc = FastClass.create(moduleClass);
        HashMap<String, MethodInvoker> fastHandlers = CollectionUtil.createHashMap(handlers.size());
        for (Map.Entry<String, Method> entry : handlers.entrySet()) {
            FastMethod fm = fc.getMethod(entry.getValue());
            fastHandlers.put(entry.getKey(), this.getMethodInvoker(fm, moduleInfo, true));
        }
        FastMethod preHandler = this.getFastMethod(fc, PRE_HANDLER);
        FastMethod postHanlder = this.getFastMethod(fc, POST_HANDLER);
        ActionEventAdapter adapter = new ActionEventAdapter(moduleObject, fastHandlers, this.getMethodInvoker(preHandler, moduleInfo, false), this.getMethodInvoker(postHanlder, moduleInfo, false));
        try {
            SpringExtUtil.autowireAndInitialize(adapter, this.context, 4, type + "." + name);
        }
        catch (Exception e) {
            throw new ModuleLoaderException("Failed to configure module adapter", e);
        }
        return adapter;
    }

    private Map<String, Method> getEventHandlers(Class<?> moduleClass) {
        HashMap<String, Method> handlers = null;
        for (Method method : moduleClass.getMethods()) {
            String methodName;
            if (!this.checkMethod(method) || (methodName = method.getName()).length() <= 2 || !methodName.startsWith("do") || !Character.isUpperCase(methodName.charAt(2))) continue;
            String eventName = StringUtil.toCamelCase(methodName.substring(2));
            if (DEFAULT_EVENT.equals(eventName)) {
                eventName = null;
            }
            if (handlers == null) {
                handlers = CollectionUtil.createHashMap();
            }
            handlers.put(eventName, method);
        }
        return handlers;
    }

    private FastMethod getFastMethod(FastClass fc, String methodName) {
        Method method = this.getMethod(fc.getJavaClass(), methodName);
        if (method == null) {
            return null;
        }
        return fc.getMethod(method);
    }
}

