/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.locale.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.locale.SetLocaleRequestContext;
import com.alibaba.citrus.service.requestcontext.locale.impl.SetLocaleOverrider;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestWrapper;
import com.alibaba.citrus.service.requestcontext.support.AbstractResponseWrapper;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleInfo;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetLocaleRequestContextImpl
extends AbstractRequestContextWrapper
implements SetLocaleRequestContext {
    private static final Logger log = LoggerFactory.getLogger(SetLocaleRequestContext.class);
    private Pattern inputCharsetPattern;
    private Pattern outputCharsetPattern;
    private SetLocaleOverrider[] overriders;
    private Locale defaultLocale;
    private String defaultCharset;
    private String sessionKey;
    private String paramKey;
    private Locale locale;

    public SetLocaleRequestContextImpl(RequestContext wrappedContext) {
        super(wrappedContext);
        this.setRequest((HttpServletRequest)new RequestWrapper(wrappedContext.getRequest()));
        this.setResponse((HttpServletResponse)new ResponseWrapper(wrappedContext.getResponse()));
    }

    public void setInputCharsetPattern(Pattern inputCharsetPattern) {
        this.inputCharsetPattern = inputCharsetPattern;
    }

    public void setOutputCharsetPattern(Pattern outputCharsetPattern) {
        this.outputCharsetPattern = outputCharsetPattern;
    }

    public void setOverriders(SetLocaleOverrider[] overriders) {
        this.overriders = overriders;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    @Override
    public String getResponseContentType() {
        return ((ResponseWrapper)this.getResponse()).getContentType();
    }

    @Override
    public void setResponseContentType(String contentType, boolean appendCharset) {
        ((ResponseWrapper)this.getResponse()).setContentType(contentType, appendCharset);
    }

    @Override
    public void setResponseCharacterEncoding(String charset) {
        ((ResponseWrapper)this.getResponse()).setCharacterEncoding(charset);
    }

    @Override
    public void prepare() {
        LocaleInfo localeInfo = this.getLocaleInfoFromSessionOrGetTheDefaultValue();
        SetLocaleOverrider overrider = this.getMatchedOverrider();
        this.setInputCharsetToRequest(localeInfo.getCharset().name(), overrider);
        if ("default".equalsIgnoreCase(this.getRequest().getParameter(this.paramKey))) {
            localeInfo = this.resetLocaleInfoInSession();
        } else {
            LocaleInfo paramLocale;
            String outputCharset = this.getOutputCharsetFromQueryString();
            if (outputCharset == null) {
                outputCharset = this.getOutputCharsetOverridden(overrider);
            }
            if ((paramLocale = this.getLocaleInfoFromParameter()) != null) {
                this.getRequest().getSession().setAttribute(this.sessionKey, (Object)paramLocale.toString());
                localeInfo = paramLocale;
            }
            if (outputCharset != null) {
                localeInfo = new LocaleInfo(localeInfo.getLocale(), outputCharset);
            }
        }
        this.getResponse().setLocale(localeInfo.getLocale());
        this.setResponseCharacterEncoding(localeInfo.getCharset().name());
        log.debug("Set OUTPUT locale:charset to " + localeInfo);
        LocaleUtil.setContext(localeInfo.getLocale(), localeInfo.getCharset().name());
        log.debug("Set THREAD CONTEXT locale:charset to " + localeInfo);
        this.locale = localeInfo.getLocale();
    }

    private SetLocaleOverrider getMatchedOverrider() {
        if (this.overriders != null) {
            String uri = this.getRequest().getRequestURI();
            for (SetLocaleOverrider overrider : this.overriders) {
                if (!overrider.getRequestUriPattern().matcher(uri).find()) continue;
                return overrider;
            }
        }
        return null;
    }

    private LocaleInfo getLocaleInfoFromSessionOrGetTheDefaultValue() {
        LocaleInfo localeInfo;
        String localeName;
        HttpSession session = this.getRequest().getSession(false);
        String string = localeName = session == null ? null : (String)this.getRequest().getSession().getAttribute(this.sessionKey);
        if (StringUtil.isEmpty(localeName)) {
            localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        } else {
            localeInfo = LocaleInfo.parse(localeName);
            if (!LocaleUtil.isLocaleSupported(localeInfo.getLocale()) || !LocaleUtil.isCharsetSupported(localeInfo.getCharset().name())) {
                log.warn("Invalid locale " + localeInfo + " from session");
                localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
            }
        }
        return localeInfo;
    }

    private void setInputCharsetToRequest(String inputCharset, SetLocaleOverrider overrider) {
        try {
            String charset = this.getInputCharsetFromQueryString();
            if (charset == null) {
                charset = this.getInputCharsetOverridden(overrider);
            }
            if (charset != null) {
                inputCharset = charset;
            }
            this.getRequest().setCharacterEncoding(inputCharset);
            log.debug("Set INPUT charset to " + inputCharset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.getRequest().setCharacterEncoding("UTF-8");
                log.warn("Unknown charset {}.  Set INPUT charset to {}", (Object)inputCharset, (Object)"UTF-8");
            }
            catch (UnsupportedEncodingException ee) {
                log.error("Failed to set INPUT charset to {}", (Object)"UTF-8");
            }
        }
    }

    private String getInputCharsetFromQueryString() {
        Matcher matcher;
        String inputCharsetQS = null;
        String queryString = this.getRequest().getQueryString();
        if (queryString != null && (matcher = this.inputCharsetPattern.matcher(queryString)).find()) {
            String charset = null;
            if (matcher.groupCount() >= 2) {
                charset = matcher.group(2);
            }
            if (LocaleUtil.isCharsetSupported(charset)) {
                inputCharsetQS = charset;
            } else {
                log.warn("Specified input charset is not supported: " + charset);
            }
        }
        return inputCharsetQS;
    }

    private String getInputCharsetOverridden(SetLocaleOverrider overrider) {
        String charset;
        String inputCharsetOverridden = null;
        if (overrider != null && (charset = overrider.getInputCharset()) != null) {
            if (LocaleUtil.isCharsetSupported(charset)) {
                inputCharsetOverridden = charset;
            } else {
                log.warn("Specified overridden input charset is not supported: " + charset);
            }
        }
        return inputCharsetOverridden;
    }

    private LocaleInfo resetLocaleInfoInSession() {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(this.sessionKey);
        }
        LocaleInfo localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        log.debug("Reset OUTPUT locale:charset to " + localeInfo);
        return localeInfo;
    }

    private String getOutputCharsetFromQueryString() {
        Matcher matcher;
        String queryString = this.getRequest().getQueryString();
        String outputCharsetQS = null;
        if (queryString != null && (matcher = this.outputCharsetPattern.matcher(queryString)).find()) {
            String charset = null;
            if (matcher.groupCount() >= 2) {
                charset = matcher.group(2);
            }
            if (LocaleUtil.isCharsetSupported(charset)) {
                outputCharsetQS = charset;
            } else {
                log.warn("Specified output charset is not supported: " + charset);
            }
        }
        return outputCharsetQS;
    }

    private String getOutputCharsetOverridden(SetLocaleOverrider overrider) {
        String charset;
        String outputCharsetOverridden = null;
        if (overrider != null && (charset = overrider.getOutputCharset()) != null) {
            if (LocaleUtil.isCharsetSupported(charset)) {
                outputCharsetOverridden = charset;
            } else {
                log.warn("Specified overridden output charset is not supported: " + charset);
            }
        }
        return outputCharsetOverridden;
    }

    private LocaleInfo getLocaleInfoFromParameter() {
        String localeName = this.getRequest().getParameter(this.paramKey);
        LocaleInfo localeInfo = null;
        if (!(StringUtil.isEmpty(localeName) || LocaleUtil.isLocaleSupported((localeInfo = LocaleInfo.parse(localeName)).getLocale()) && LocaleUtil.isCharsetSupported(localeInfo.getCharset().name()))) {
            log.warn("Invalid locale " + localeInfo + " from request parameters");
            localeInfo = new LocaleInfo(this.defaultLocale, this.defaultCharset);
        }
        return localeInfo;
    }

    private class ResponseWrapper
    extends AbstractResponseWrapper {
        private String contentType;
        private String charset;

        public ResponseWrapper(HttpServletResponse response) {
            super(SetLocaleRequestContextImpl.this, response);
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.setContentType(contentType, true);
        }

        public void setContentType(String contentType, boolean appendCharset) {
            String charset = StringUtil.trimToNull(StringUtil.substringAfterLast(contentType, "charset="));
            if (charset == null) {
                charset = this.charset;
            }
            this.contentType = StringUtil.trimToNull(StringUtil.substringBefore(contentType, ";"));
            this.setCharacterEncoding(appendCharset ? charset : null);
        }

        public String getCharacterEncoding() {
            return super.getCharacterEncoding();
        }

        public void setCharacterEncoding(String charset) {
            this.charset = charset;
            if (this.contentType != null) {
                this.contentType = StringUtil.trimToNull(StringUtil.substringBefore(this.contentType, ";"));
                if (charset != null) {
                    this.contentType = this.contentType + "; charset=" + charset;
                }
                log.debug("Set content type to " + this.contentType);
                super.setContentType(this.contentType);
            } else {
                try {
                    super.setCharacterEncoding(charset);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    private class RequestWrapper
    extends AbstractRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(SetLocaleRequestContextImpl.this, request);
        }

        public Locale getLocale() {
            return SetLocaleRequestContextImpl.this.locale == null ? super.getLocale() : SetLocaleRequestContextImpl.this.locale;
        }
    }
}

