/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.encrypter.impl;

import com.alibaba.citrus.service.requestcontext.session.encrypter.AbstractJceEncrypter;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AesEncrypter
extends AbstractJceEncrypter {
    public static final String ALG_NAME = "AES";
    public static final int DEFAULT_KEY_SIZE = 128;
    private String key;
    private int keySize;
    private SecretKeySpec keySpec;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = StringUtil.trimToNull(key);
    }

    public int getKeySize() {
        return this.keySize <= 0 ? 128 : this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    protected void init() throws Exception {
        Assert.assertNotNull(this.key, "no key", new Object[0]);
        byte[] raw = this.key.getBytes("UTF-8");
        int keySize = this.getKeySize();
        int actualKeySize = raw.length * 8;
        Assert.assertTrue(keySize == actualKeySize, "Illegal key: expected size=%d, actual size is %d", keySize, actualKeySize);
        this.keySpec = new SecretKeySpec(raw, ALG_NAME);
    }

    @Override
    protected Cipher createCipher(int mode) throws Exception {
        Cipher cipher = Cipher.getInstance(ALG_NAME);
        cipher.init(mode, this.keySpec);
        return cipher;
    }

    @Override
    public String toString() {
        return "AES(keySize=" + this.getKeySize() + ")";
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<AesEncrypter> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "keySize", "key");
        }
    }
}

