/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.valueencoder.impl;

import com.alibaba.citrus.service.configuration.support.PropertyEditorRegistrarsSupport;
import com.alibaba.citrus.service.requestcontext.session.valueencoder.AbstractSessionValueEncoder;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SimpleValueEncoder
extends AbstractSessionValueEncoder {
    private Class<?> type;

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    protected boolean doURLEncode() {
        return true;
    }

    @Override
    protected boolean doCompress() {
        return false;
    }

    @Override
    protected String encodeValue(Object value) throws Exception {
        return this.convertToString(this.type, value, this.getTypeConverter());
    }

    @Override
    protected Object decodeValue(String encodedValue) throws Exception {
        return this.convertToType(this.type, encodedValue, this.getTypeConverter());
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<SimpleValueEncoder>
    implements ContributionAware {
        private ConfigurationPoint encrypterConfigurationPoint;

        @Override
        public void setContribution(Contribution contrib) {
            this.encrypterConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/request-contexts/session/encrypters", contrib);
        }

        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "type", "charset");
            builder.addPropertyValue("propertyEditorRegistrars", PropertyEditorRegistrarsSupport.parseRegistrars(element, parserContext, builder));
            for (Element subElement : DomUtil.subElements(element)) {
                BeanDefinitionHolder encrypter = SpringExtUtil.parseConfigurationPointBean(subElement, this.encrypterConfigurationPoint, parserContext, builder);
                if (encrypter == null) continue;
                builder.addPropertyValue("encrypter", (Object)encrypter);
                break;
            }
        }
    }
}

