/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.ResourceNotFoundException;
import com.alibaba.citrus.service.resource.ResourceTrace;
import com.alibaba.citrus.service.resource.impl.ResourceFilterMapping;
import com.alibaba.citrus.service.resource.impl.ResourceListerContextImpl;
import com.alibaba.citrus.service.resource.impl.ResourceLoaderContextImpl;
import com.alibaba.citrus.service.resource.impl.ResourceMapping;
import com.alibaba.citrus.service.resource.impl.ResourcePattern;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ResourceLoadingServiceImpl
extends AbstractService<ResourceLoadingService>
implements ResourceLoadingService,
ApplicationContextAware {
    public static final String DEFAULT_NAME = "resourceLoadingService";
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];
    private ApplicationContext factory;
    private ResourceLoadingService parent;
    private ResourceMapping[] resourceMappings;
    private ResourceFilterMapping[] filterMappings;
    private String configLocation;

    public void setApplicationContext(ApplicationContext factory) throws BeansException {
        this.factory = factory;
    }

    @Override
    public ResourceLoadingService getParent() {
        return this.parent;
    }

    public void setParent(ResourceLoadingService parent) {
        this.parent = parent;
    }

    public void setResourceMappings(ResourceMapping[] mappings) {
        this.resourceMappings = mappings;
    }

    public void setFilterMappings(ResourceFilterMapping[] filterMappings) {
        this.filterMappings = filterMappings;
    }

    public void setConfigLocation(URL configLocation) {
        this.configLocation = configLocation.toExternalForm();
    }

    @Override
    protected void init() {
        Assert.assertNotNull(this.factory, "beanFactory", new Object[0]);
        if (this.parent == null && this.factory.getParent() != null) {
            String parentBeanName = null;
            if (this.factory.getParent().containsBean(this.getBeanName())) {
                parentBeanName = this.getBeanName();
            } else if (this.factory.getParent().containsBean(DEFAULT_NAME)) {
                parentBeanName = DEFAULT_NAME;
            }
            if (parentBeanName != null) {
                this.parent = (ResourceLoadingService)this.factory.getParent().getBean(parentBeanName);
            }
        }
        if (this.resourceMappings == null) {
            this.resourceMappings = new ResourceMapping[0];
        }
        for (ResourceMapping resourceMapping : this.resourceMappings) {
            resourceMapping.init(this);
        }
        if (this.filterMappings == null) {
            this.filterMappings = new ResourceFilterMapping[0];
        }
        for (ResourcePattern resourcePattern : this.filterMappings) {
            resourcePattern.init(this);
        }
    }

    @Override
    public URL getResourceAsURL(String resourceName) throws ResourceNotFoundException {
        return this.checkResource(this.getResource(resourceName).getURL(), resourceName, URL.class);
    }

    @Override
    public File getResourceAsFile(String resourceName) throws ResourceNotFoundException {
        return this.checkResource(this.getResource(resourceName).getFile(), resourceName, File.class);
    }

    @Override
    public File getResourceAsFile(String resourceName, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        return this.checkResource(this.getResource(resourceName, options).getFile(), resourceName, File.class);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) throws ResourceNotFoundException, IOException {
        return this.checkResource(this.getResource(resourceName).getInputStream(), resourceName, InputStream.class);
    }

    private <T> T checkResource(T resource, String resourceName, Class<T> type) throws ResourceNotFoundException {
        if (resource == null) {
            throw new ResourceNotFoundException(String.format("Could not get %s of resource \"%s\"", type.getSimpleName(), resourceName));
        }
        return resource;
    }

    @Override
    public Resource getResource(String resourceName) throws ResourceNotFoundException {
        return this.getResource(resourceName, null);
    }

    @Override
    public Resource getResource(String resourceName, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        this.assertInitialized();
        return new ResourceLoaderContextImpl(resourceName, options, this.filterMappings, this.resourceMappings, this.getParent(), this.getLogger(), this.configLocation, this.getBeanName()).getResource();
    }

    @Override
    public boolean exists(String resourceName) {
        try {
            this.getResource(resourceName);
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    @Override
    public ResourceTrace trace(String resourceName) {
        return this.trace(resourceName, FOR_CREATE);
    }

    @Override
    public ResourceTrace trace(String resourceName, Set<ResourceLoadingOption> options) {
        this.assertInitialized();
        return new ResourceLoaderContextImpl(resourceName, options, this.filterMappings, this.resourceMappings, this.getParent(), this.getLogger(), this.configLocation, this.getBeanName()).getTrace();
    }

    @Override
    public String[] list(String resourceName) throws ResourceNotFoundException {
        return this.list(resourceName, null);
    }

    @Override
    public String[] list(String resourceName, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        this.assertInitialized();
        return new ResourceListerContextImpl(resourceName, options, this.resourceMappings, this.getParent(), this.getLogger()).list();
    }

    @Override
    public Resource[] listResources(String resourceName) throws ResourceNotFoundException {
        return this.listResources(resourceName, null);
    }

    @Override
    public Resource[] listResources(String resourceName, Set<ResourceLoadingOption> options) throws ResourceNotFoundException {
        String[] names = this.list(resourceName, options);
        if (ArrayUtil.isEmptyArray(names)) {
            return EMPTY_RESOURCE_ARRAY;
        }
        ArrayList<Resource> resources = CollectionUtil.createArrayList(names.length);
        for (String name : names) {
            String subResourceName = resourceName + "/" + name;
            try {
                resources.add(this.getResource(subResourceName));
            }
            catch (ResourceNotFoundException e) {
                // empty catch block
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public String[] getPatterns(boolean includeParent) {
        LinkedHashSet<String> patterns = CollectionUtil.createLinkedHashSet();
        for (ResourceMapping mapping : this.resourceMappings) {
            if (mapping.isInternal()) continue;
            patterns.add(mapping.getPatternName());
        }
        if (includeParent && this.parent != null) {
            for (String pattern : this.parent.getPatterns(true)) {
                patterns.add(pattern);
            }
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("configLocation", this.configLocation);
        mb.append("resourceMappings", this.resourceMappings);
        mb.append("filterMappings", this.filterMappings);
        if (this.parent != null) {
            mb.append("parent", this.parent);
        }
        return new ToStringBuilder().append(this.getBeanDescription()).append(mb).toString();
    }
}

