/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.resolver;

import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.Schemas;
import com.alibaba.citrus.springext.impl.SchemaImpl;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class SpringPluggableSchemas
implements Schemas {
    private static final Logger log = LoggerFactory.getLogger(SpringPluggableSchemas.class);
    private static final String SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Pattern SCHEMA_VERSION_PATTERN = Pattern.compile("-((\\d+)(.\\d+)*)\\.xsd$");
    private final ResourceLoader resourceLoader;
    private final Map<String, Schema> nameToSchemaMappings;
    private final Map<String, String> uriToNameMappings;
    private boolean initialized;

    public SpringPluggableSchemas() {
        this(null);
    }

    public SpringPluggableSchemas(ResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            resourceLoader = new DefaultResourceLoader();
        }
        this.resourceLoader = resourceLoader;
        this.nameToSchemaMappings = CollectionUtil.createTreeMap();
        this.uriToNameMappings = CollectionUtil.createTreeMap();
    }

    @Override
    public Map<String, Schema> getNamedMappings() {
        this.ensureInit();
        return this.nameToSchemaMappings;
    }

    public Map<String, String> getUriToNameMappings() {
        this.ensureInit();
        return this.uriToNameMappings;
    }

    private void ensureInit() {
        Properties uriToClasspathLocationMappings;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        log.trace("Trying to load Spring schema mappings at {}", (Object)SCHEMA_MAPPINGS_LOCATION);
        try {
            uriToClasspathLocationMappings = PropertiesLoaderUtils.loadAllProperties((String)SCHEMA_MAPPINGS_LOCATION, (ClassLoader)this.resourceLoader.getClassLoader());
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Unable to load Spring schema mappings from META-INF/spring.schemas", e);
        }
        String desc = "SpringSchema[META-INF/spring.schemas]";
        for (Map.Entry<Object, Object> entry : uriToClasspathLocationMappings.entrySet()) {
            InputStreamSource source;
            String uri = StringUtil.trimToNull((String)entry.getKey());
            String classpathLocation = StringUtil.trimToNull((String)entry.getValue());
            String schemaName = this.getSchemaName(uri);
            Matcher matcher = SCHEMA_VERSION_PATTERN.matcher(schemaName);
            String version = null;
            if (matcher.find()) {
                version = matcher.group(1);
            }
            if ((source = this.getResource(classpathLocation, uri)) == null) continue;
            this.nameToSchemaMappings.put(schemaName, new SchemaImpl(schemaName, version, true, desc, source));
            this.uriToNameMappings.put(uri, schemaName);
        }
        if (log.isDebugEnabled() && !this.uriToNameMappings.isEmpty()) {
            ToStringBuilder buf = new ToStringBuilder();
            buf.format("Loaded Spring schema mappings at %s, %d schemas found.", SCHEMA_MAPPINGS_LOCATION, this.uriToNameMappings.size()).appendMap(this.uriToNameMappings);
            log.debug(buf.toString());
        }
    }

    private InputStreamSource getResource(String classpathLocation, String uri) {
        URL resource;
        if (!classpathLocation.startsWith("classpath:")) {
            classpathLocation = "classpath:" + classpathLocation;
        }
        try {
            resource = this.resourceLoader.getResource(classpathLocation).getURL();
        }
        catch (Exception e) {
            log.warn("Could not find schema {} for URI: {},\n  {}", (Object[])new String[]{classpathLocation, uri, e.getMessage()});
            return null;
        }
        return new UrlResource(resource){

            public String getDescription() {
                try {
                    return this.getURL().toExternalForm();
                }
                catch (IOException e) {
                    Assert.unexpectedException(e);
                    return null;
                }
            }
        };
    }

    private String getSchemaName(String uri) {
        return URI.create(uri).normalize().getSchemeSpecificPart().replaceAll("^/+|/+$", "");
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder();
        buf.format("SpringPluggableSchemas[loaded from %s]", SCHEMA_MAPPINGS_LOCATION);
        buf.appendMap(this.uriToNameMappings);
        return buf.toString();
    }
}

