/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.auth.PageAuthorizationService;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PageAuthorizationValve
extends AbstractValve {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private PageAuthorizationService pageAuthorizationService;
    private Callback<?> callback;

    public void setCallback(Callback<?> callback) {
        this.callback = callback;
    }

    @Override
    protected void init() throws Exception {
        if (this.callback == null) {
            this.callback = new DefaultCallback();
        }
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        String[] extraActions;
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        Callback<?> cb = this.callback;
        Object status = cb.onStart(rundata);
        String userName = cb.getUserName(status);
        String[] roleNames = cb.getRoleNames(status);
        String target = rundata.getTarget();
        String action = rundata.getAction();
        String event = StringUtil.capitalize(rundata.getActionEvent());
        LinkedList<String> actions = CollectionUtil.createLinkedList();
        actions.add("screen");
        if (action != null) {
            if (event != null) {
                actions.add("action." + action + ".do" + event);
            } else {
                actions.add("action." + action);
            }
        }
        if (!ArrayUtil.isEmptyArray(extraActions = cb.getActions(status))) {
            for (String extraAction : extraActions) {
                actions.add(extraAction);
            }
        }
        if (this.pageAuthorizationService.isAllow(target, userName, roleNames, actions.toArray(new String[actions.size()]))) {
            cb.onAllow(status);
            pipelineContext.invokeNext();
        } else {
            cb.onDeny(status);
        }
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PageAuthorizationValve> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            element.setAttribute("class", element.getAttribute("callbackClass"));
            builder.addPropertyValue("callback", SpringExtUtil.parseBean(element, parserContext, builder));
        }
    }

    private class DefaultCallback
    implements Callback<TurbineRunData> {
        private DefaultCallback() {
        }

        @Override
        public String getUserName(TurbineRunData status) {
            return null;
        }

        @Override
        public String[] getRoleNames(TurbineRunData status) {
            return null;
        }

        @Override
        public String[] getActions(TurbineRunData status) {
            return null;
        }

        @Override
        public TurbineRunData onStart(TurbineRunData rundata) {
            return rundata;
        }

        @Override
        public void onAllow(TurbineRunData status) throws Exception {
        }

        @Override
        public void onDeny(TurbineRunData status) {
        }
    }

    public static interface Callback<T> {
        public String getUserName(T var1);

        public String[] getRoleNames(T var1);

        public String[] getActions(T var1);

        public T onStart(TurbineRunData var1) throws Exception;

        public void onAllow(T var1) throws Exception;

        public void onDeny(T var1) throws Exception;
    }
}

