/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.pipeline.valve;

import com.alibaba.citrus.service.mappingrule.MappingRuleService;
import com.alibaba.citrus.service.moduleloader.Module;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderException;
import com.alibaba.citrus.service.moduleloader.ModuleLoaderService;
import com.alibaba.citrus.service.moduleloader.ModuleNotFoundException;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.turbine.TurbineRunData;
import com.alibaba.citrus.turbine.util.TurbineUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.webx.WebxException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PerformScreenValve
extends AbstractValve {
    @Autowired
    private ModuleLoaderService moduleLoaderService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private MappingRuleService mappingRuleService;

    public MappingRuleService getMappingRuleService() {
        return this.mappingRuleService;
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        TurbineRunData rundata = TurbineUtil.getTurbineRunData(this.request);
        if (!rundata.isRedirected()) {
            this.setContentType(rundata);
            this.performScreenModule(rundata);
        }
        pipelineContext.invokeNext();
    }

    protected void setContentType(TurbineRunData rundata) {
        if (StringUtil.isEmpty(rundata.getResponse().getContentType())) {
            rundata.getResponse().setContentType("text/html");
        }
    }

    protected void performScreenModule(TurbineRunData rundata) {
        String target = Assert.assertNotNull(rundata.getTarget(), "Target was not specified", new Object[0]);
        String moduleName = this.getModuleName(target);
        rundata.setLayoutEnabled(true);
        try {
            Module module = this.moduleLoaderService.getModuleQuiet("screen", moduleName);
            if (module != null) {
                module.execute();
            } else if (this.isScreenModuleRequired()) {
                throw new ModuleNotFoundException("Could not find screen module: " + moduleName);
            }
        }
        catch (ModuleLoaderException e) {
            throw new WebxException("Failed to load screen module: " + moduleName, e);
        }
        catch (Exception e) {
            throw new WebxException("Failed to execute screen: " + moduleName, e);
        }
    }

    protected boolean isScreenModuleRequired() {
        return true;
    }

    protected String getModuleName(String target) {
        return this.mappingRuleService.getMappedName("screen.notemplate", target);
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<PerformScreenValve> {
    }
}

