/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.IllegalPathException;
import com.alibaba.citrus.util.StringUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    private static final Pattern schemePrefixPattern = Pattern.compile("(file:/*[a-z]:)|(\\w+://.+?/)|((jar|zip):.+!/)|(\\w+:)", 2);

    public static String normalizeAbsolutePath(String path) throws IllegalPathException {
        return FileUtil.normalizePath(path, true, false, false);
    }

    public static String normalizeAbsolutePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileUtil.normalizePath(path, true, false, removeTrailingSlash);
    }

    public static String normalizeRelativePath(String path) throws IllegalPathException {
        return FileUtil.normalizePath(path, false, true, false);
    }

    public static String normalizeRelativePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileUtil.normalizePath(path, false, true, removeTrailingSlash);
    }

    public static String normalizePath(String path) throws IllegalPathException {
        return FileUtil.normalizePath(path, false, false, false);
    }

    public static String normalizePath(String path, boolean removeTrailingSlash) throws IllegalPathException {
        return FileUtil.normalizePath(path, false, false, removeTrailingSlash);
    }

    private static String normalizePath(String path, boolean forceAbsolute, boolean forceRelative, boolean removeTrailingSlash) throws IllegalPathException {
        char[] pathChars = StringUtil.trimToEmpty(path).toCharArray();
        int length = pathChars.length;
        boolean startsWithSlash = false;
        boolean endsWithSlash = false;
        if (length > 0) {
            char firstChar = pathChars[0];
            char lastChar = pathChars[length - 1];
            startsWithSlash = firstChar == '/' || firstChar == '\\';
            endsWithSlash = lastChar == '/' || lastChar == '\\';
        }
        StringBuilder buf = new StringBuilder(length);
        boolean isAbsolutePath = forceAbsolute || !forceRelative && startsWithSlash;
        int index = startsWithSlash ? 0 : -1;
        int level = 0;
        if (isAbsolutePath) {
            buf.append("/");
        }
        while (index < length && (index = FileUtil.indexOfSlash(pathChars, index + 1, false)) != length) {
            int nextSlashIndex = FileUtil.indexOfSlash(pathChars, index, true);
            String element = new String(pathChars, index, nextSlashIndex - index);
            index = nextSlashIndex;
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                if (level == 0) {
                    if (isAbsolutePath) {
                        throw new IllegalPathException(path);
                    }
                    buf.append("../");
                    continue;
                }
                buf.setLength(pathChars[--level]);
                continue;
            }
            pathChars[level++] = (char)buf.length();
            buf.append(element).append('/');
        }
        if (buf.length() > 0 && (!endsWithSlash || removeTrailingSlash)) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private static int indexOfSlash(char[] chars, int beginIndex, boolean slash) {
        int i;
        for (i = beginIndex; i < chars.length; ++i) {
            char ch = chars[i];
            if (slash ? ch == '/' || ch == '\\' : ch != '/' && ch != '\\') break;
        }
        return i;
    }

    public static String getAbsolutePathBasedOn(String basedir, String path) throws IllegalPathException {
        boolean isAbsolutePath = false;
        if ((path = StringUtil.trimToEmpty(path)).length() > 0) {
            char firstChar = path.charAt(0);
            boolean bl = isAbsolutePath = firstChar == '/' || firstChar == '\\';
        }
        if (!isAbsolutePath) {
            path = path.length() > 0 ? StringUtil.trimToEmpty(basedir) + "/" + path : StringUtil.trimToEmpty(basedir);
        }
        return FileUtil.normalizeAbsolutePath(path);
    }

    public static String getSystemDependentAbsolutePathBasedOn(String basedir, String path) {
        boolean endsWithSlash = (path = StringUtil.trimToEmpty(path)).endsWith("/") || path.endsWith("\\");
        File pathFile = new File(path);
        if (pathFile.isAbsolute()) {
            path = pathFile.getAbsolutePath();
        } else {
            File baseFile = new File(basedir = StringUtil.trimToEmpty(basedir));
            if (baseFile.isAbsolute()) {
                path = new File(baseFile, path).getAbsolutePath();
            } else {
                throw new IllegalPathException("Basedir is not absolute path: " + basedir);
            }
        }
        if (endsWithSlash) {
            path = path + '/';
        }
        return FileUtil.normalizePath(path);
    }

    public static String getRelativePath(String basedir, String path) throws IllegalPathException {
        int i;
        basedir = FileUtil.normalizeAbsolutePath(basedir);
        path = FileUtil.getAbsolutePathBasedOn(basedir, path);
        boolean endsWithSlash = path.endsWith("/");
        String[] baseParts = StringUtil.split(basedir, '/');
        String[] parts = StringUtil.split(path, '/');
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < baseParts.length && i < parts.length && baseParts[i].equals(parts[i]); ++i) {
        }
        if (i < baseParts.length && i < parts.length) {
            for (int j = i; j < baseParts.length; ++j) {
                buf.append("..").append('/');
            }
        }
        while (i < parts.length) {
            buf.append(parts[i]);
            if (i < parts.length - 1) {
                buf.append('/');
            }
            ++i;
        }
        if (endsWithSlash && buf.length() > 0 && buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        return buf.toString();
    }

    public static String getExtension(String fileName) {
        return FileUtil.getExtension(fileName, null, false);
    }

    public static String getExtension(String fileName, boolean toLowerCase) {
        return FileUtil.getExtension(fileName, null, toLowerCase);
    }

    public static String getExtension(String fileName, String nullExt) {
        return FileUtil.getExtension(fileName, nullExt, false);
    }

    public static String getExtension(String fileName, String nullExt, boolean toLowerCase) {
        if ((fileName = StringUtil.trimToNull(fileName)) == null) {
            return null;
        }
        fileName = fileName.replace('\\', '/');
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        int index = fileName.lastIndexOf(".");
        String ext = null;
        if (index >= 0) {
            ext = StringUtil.trimToNull(fileName.substring(index + 1));
        }
        if (ext == null) {
            return nullExt;
        }
        return toLowerCase ? ext.toLowerCase() : ext;
    }

    public static FileNameAndExtension getFileNameAndExtension(String path) {
        return FileUtil.getFileNameAndExtension(path, false);
    }

    public static FileNameAndExtension getFileNameAndExtension(String path, boolean extensionToLowerCase) {
        String fileName = path = StringUtil.trimToEmpty(path);
        String extension = null;
        if (!StringUtil.isEmpty(path)) {
            int index = path.lastIndexOf(46);
            if (index >= 0 && !StringUtil.containsNone(extension = StringUtil.trimToNull(StringUtil.substring(path, index + 1)), "/\\")) {
                extension = null;
                index = -1;
            }
            if (index >= 0) {
                fileName = StringUtil.substring(path, 0, index);
            }
        }
        return new FileNameAndExtension(fileName, extension, extensionToLowerCase);
    }

    public static String normalizeExtension(String ext) {
        if ((ext = StringUtil.trimToNull(ext)) != null && (ext = ext.toLowerCase()).startsWith(".")) {
            ext = StringUtil.trimToNull(ext.substring(1));
        }
        return ext;
    }

    public static String resolve(String url, String relativePath) {
        url = StringUtil.trimToEmpty(url);
        Matcher m = schemePrefixPattern.matcher(url);
        int index = 0;
        if (m.find() && url.charAt((index = m.end()) - 1) == '/') {
            --index;
        }
        return url.substring(0, index) + FileUtil.normalizeAbsolutePath(url.substring(index) + "/../" + relativePath);
    }

    public static class FileNameAndExtension {
        private final String fileName;
        private final String extension;

        private FileNameAndExtension(String fileName, String extension, boolean extensionToLowerCase) {
            this.fileName = fileName;
            this.extension = extensionToLowerCase ? StringUtil.toLowerCase(extension) : extension;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getExtension() {
            return this.extension;
        }

        public String toString() {
            return this.extension == null ? this.fileName : this.fileName + "." + this.extension;
        }
    }
}

