/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.i18n;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;

public final class LocaleInfo
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 3257847675461251635L;
    private Locale locale;
    private Charset charset;

    public static LocaleInfo parse(String name) {
        name = Assert.assertNotNull(StringUtil.trimToNull(name), "no locale name", new Object[0]);
        int index = name.indexOf(":");
        String localePart = name;
        String charsetPart = null;
        if (index >= 0) {
            localePart = name.substring(0, index);
            charsetPart = name.substring(index + 1);
        }
        Locale locale = LocaleUtil.parseLocale(localePart);
        String charset = StringUtil.trimToNull(charsetPart);
        return new LocaleInfo(locale, charset);
    }

    public LocaleInfo() {
        this.locale = Assert.assertNotNull(Locale.getDefault(), "system locale", new Object[0]);
        this.charset = Assert.assertNotNull(Charset.defaultCharset(), "system charset", new Object[0]);
    }

    public LocaleInfo(Locale locale) {
        this(locale, null, LocaleUtil.getDefault());
    }

    public LocaleInfo(Locale locale, String charset) {
        this(locale, charset, LocaleUtil.getDefault());
    }

    LocaleInfo(Locale locale, String charset, LocaleInfo fallbackLocaleInfo) {
        Assert.assertNotNull(fallbackLocaleInfo, "fallbackLocaleInfo", new Object[0]);
        charset = StringUtil.trimToNull(charset);
        if (locale == null) {
            locale = fallbackLocaleInfo.getLocale();
            if (charset == null) {
                charset = fallbackLocaleInfo.getCharset().name();
            }
        } else if (charset == null) {
            charset = "UTF-8";
        }
        this.locale = locale;
        try {
            this.charset = Charset.forName(charset);
        }
        catch (UnsupportedCharsetException e) {
            this.charset = new UnknownCharset(charset);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isCharsetSupported() {
        return !(this.charset instanceof UnknownCharset);
    }

    public LocaleInfo assertCharsetSupported() throws UnsupportedCharsetException {
        if (this.charset instanceof UnknownCharset) {
            throw new UnsupportedCharsetException(this.charset.name());
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocaleInfo)) {
            return false;
        }
        LocaleInfo otherLocaleInfo = (LocaleInfo)o;
        return this.locale.equals(otherLocaleInfo.locale) && this.charset.equals(otherLocaleInfo.charset);
    }

    public int hashCode() {
        return this.charset.hashCode() * 31 + this.locale.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.unexpectedException(e);
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        LocaleInfo info = LocaleInfo.parse(in.readUTF());
        this.locale = info.getLocale();
        this.charset = info.getCharset();
    }

    public String toString() {
        return this.locale + ":" + this.charset;
    }

    static class UnknownCharset
    extends Charset {
        public UnknownCharset(String name) {
            super(Assert.assertNotNull(name, "charset name", new Object[0]), null);
        }

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            Assert.unsupportedOperation("Could not create decoder for unknown charset: " + this.name(), new Object[0]);
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            Assert.unsupportedOperation("Could not create encoder for unknown charset: " + this.name(), new Object[0]);
            return null;
        }
    }
}

