/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassUtil;

public abstract class LazyLoader<T, C> {
    private final Loader<T, C> loader;

    protected LazyLoader(Loader<T, C> loader) {
        this.loader = Assert.assertNotNull(loader);
    }

    public final T getInstance() {
        return this.getInstance(null);
    }

    public abstract T getInstance(C var1);

    public abstract boolean testInstance();

    protected final T load(C context) {
        try {
            return this.loader.load(context);
        }
        catch (RuntimeException e) {
            if (this.loader instanceof ExceptionHandler) {
                return ((ExceptionHandler)this.loader).handle(e, context);
            }
            throw e;
        }
    }

    public static <T, C> LazyLoader<T, C> getDefault(Loader<T, C> loader) {
        return LazyLoader.getDoubleCheckedLockingLazyLoader(loader);
    }

    public static <T, C> LazyLoader<T, C> getSynchronizedLazyLoader(Loader<T, C> loader) {
        return new LazyLoader<T, C>((Loader)loader){
            private boolean loaded;
            private T instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T getInstance(C context) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (!this.loaded) {
                        this.instance = this.load(context);
                        this.loaded = true;
                    }
                }
                return this.instance;
            }

            @Override
            public synchronized boolean testInstance() {
                return this.loaded;
            }
        };
    }

    public static <T, C> LazyLoader<T, C> getPerThreadLazyLoader(Loader<T, C> loader) {
        return new LazyLoader<T, C>((Loader)loader){
            private final ThreadLocal<Boolean> synced = new ThreadLocal();
            private boolean loaded;
            private T instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T getInstance(C context) {
                if (this.synced.get() == null) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.loaded) {
                            this.instance = this.load(context);
                            this.loaded = true;
                        }
                    }
                    this.synced.set(Boolean.TRUE);
                }
                return this.instance;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean testInstance() {
                if (this.synced.get() == null) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.loaded) {
                            this.synced.set(Boolean.TRUE);
                        }
                        return this.loaded;
                    }
                }
                return true;
            }
        };
    }

    public static <T, C> LazyLoader<T, C> getDoubleCheckedLockingLazyLoader(Loader<T, C> loader) {
        return new LazyLoader<T, C>((Loader)loader){
            private volatile boolean loaded;
            private volatile T instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T getInstance(C context) {
                if (!this.loaded) {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        if (!this.loaded) {
                            this.instance = this.load(context);
                            this.loaded = true;
                        }
                    }
                }
                return this.instance;
            }

            @Override
            public boolean testInstance() {
                return this.loaded;
            }
        };
    }

    public String toString() {
        return String.format("LazyLoader(%s%s)", ClassUtil.getSimpleClassName(this.loader.getClass()), this.testInstance() ? ", loaded" : "");
    }

    public static interface ExceptionHandler<T, C>
    extends Loader<T, C> {
        public T handle(RuntimeException var1, C var2);
    }

    public static interface Loader<T, C> {
        public T load(C var1);
    }
}

