/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.support;

import com.alibaba.citrus.webx.WebxComponent;
import com.alibaba.citrus.webx.WebxController;
import com.alibaba.citrus.webx.config.WebxConfiguration;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

public abstract class AbstractWebxController
implements WebxController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WebxComponent component;

    public WebxComponent getComponent() {
        return this.component;
    }

    public WebxConfiguration getWebxConfiguration() {
        return this.getComponent().getWebxConfiguration();
    }

    public ServletContext getServletContext() {
        return this.getComponent().getApplicationContext().getServletContext();
    }

    @Override
    public void init(WebxComponent component) {
        this.component = component;
    }

    @Override
    public void onRefreshContext() throws BeansException {
        this.initWebxConfiguration();
    }

    private void initWebxConfiguration() {
        WebxConfiguration webxConfiguration = this.getWebxConfiguration();
        this.log.debug("Initializing WebxComponent \"{}\" in {} mode, according to <webx-configuration>", (Object)this.getComponent().getName(), (Object)(webxConfiguration.isProductionMode() ? "production" : "development"));
    }

    @Override
    public void onFinishedProcessContext() {
    }
}

