/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.util;

import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.PathNameWildcardCompiler;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class RequestURIFilter {
    private final String[] uris;
    private final Pattern[] patterns;

    public RequestURIFilter(String uris) {
        LinkedList<String> names = CollectionUtil.createLinkedList();
        LinkedList<Pattern> patterns = CollectionUtil.createLinkedList();
        for (String uri : StringUtil.split(ObjectUtil.defaultIfNull(uris, ""), ", \r\n")) {
            if ((uri = StringUtil.trimToNull(uri)) == null) continue;
            names.add(uri);
            patterns.add(PathNameWildcardCompiler.compilePathName(uri));
        }
        if (!patterns.isEmpty()) {
            this.uris = names.toArray(new String[names.size()]);
            this.patterns = patterns.toArray(new Pattern[patterns.size()]);
        } else {
            this.uris = BasicConstant.EMPTY_STRING_ARRAY;
            this.patterns = null;
        }
    }

    public boolean matches(HttpServletRequest request) {
        if (this.patterns != null) {
            String requestURI = request.getRequestURI();
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(requestURI).find()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder().append("FilterOf").append(this.uris).toString();
    }
}

