/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.connection;

import com.alibaba.csp.sentinel.cluster.server.connection.Connection;
import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionPool;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class NettyConnection
implements Connection {
    private String remoteIp;
    private int remotePort;
    private Channel channel;
    private long lastReadTime;
    private ConnectionPool pool;

    public NettyConnection(Channel channel, ConnectionPool pool) {
        this.channel = channel;
        this.pool = pool;
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        this.remoteIp = socketAddress.getAddress().getHostAddress();
        this.remotePort = socketAddress.getPort();
        this.lastReadTime = System.currentTimeMillis();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getRemoteIP() {
        return this.remoteIp;
    }

    @Override
    public void refreshLastReadTime(long lastReadTime) {
        this.lastReadTime = lastReadTime;
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public String getConnectionKey() {
        return this.remoteIp + ":" + this.remotePort;
    }

    @Override
    public void close() {
        this.pool.remove(this.channel);
        if (this.channel != null && this.channel.isActive()) {
            this.channel.close();
        }
    }
}

