/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03.handlers;

import com.alibaba.excel.analysis.v03.AbstractXlsRecordHandler;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.util.SheetUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.Record;

public class BofRecordHandler
extends AbstractXlsRecordHandler {
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private BoundSheetRecord[] orderedBsrs;
    private int sheetIndex;
    private List<ReadSheet> sheets;
    private Boolean readAll;
    private List<ReadSheet> readSheetList;
    private AnalysisContext context;
    private boolean alreadyInit;
    private boolean needInitSheet;

    public BofRecordHandler(AnalysisContext context, List<ReadSheet> sheets, boolean alreadyInit, boolean needInitSheet) {
        this.context = context;
        this.sheets = sheets;
        this.alreadyInit = alreadyInit;
        this.needInitSheet = needInitSheet;
    }

    @Override
    public boolean support(Record record) {
        return 133 == record.getSid() || 2057 == record.getSid();
    }

    @Override
    public void processRecord(Record record) {
        BOFRecord br;
        if (record.getSid() == 133) {
            this.boundSheetRecords.add((BoundSheetRecord)record);
        } else if (record.getSid() == 2057 && (br = (BOFRecord)record).getType() == 16) {
            if (this.orderedBsrs == null) {
                this.orderedBsrs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
            }
            String sheetName = this.orderedBsrs[this.sheetIndex].getSheetname();
            ReadSheet readSheet = null;
            if (!this.alreadyInit) {
                readSheet = new ReadSheet(this.sheetIndex, sheetName);
                this.sheets.add(readSheet);
            }
            if (this.needInitSheet) {
                if (readSheet == null) {
                    for (ReadSheet sheet : this.sheets) {
                        if (sheet.getSheetNo() != this.sheetIndex) continue;
                        readSheet = sheet;
                        break;
                    }
                }
                assert (readSheet != null) : "Can't find the sheet.";
                this.context.readWorkbookHolder().setIgnoreRecord03(Boolean.TRUE);
                readSheet = SheetUtils.match(readSheet, this.readSheetList, this.readAll, this.context.readWorkbookHolder().getGlobalConfiguration());
                if (readSheet != null) {
                    if (readSheet.getSheetNo() != 0 && this.context.readSheetHolder() != null) {
                        this.context.readSheetHolder().notifyAfterAllAnalysed(this.context);
                    }
                    this.context.currentSheet(readSheet);
                    this.context.readWorkbookHolder().setIgnoreRecord03(Boolean.FALSE);
                }
            }
            ++this.sheetIndex;
        }
    }

    @Override
    public void init() {
        this.sheetIndex = 0;
        this.orderedBsrs = null;
        this.boundSheetRecords.clear();
        if (!this.alreadyInit) {
            this.sheets.clear();
        }
    }

    public void init(List<ReadSheet> readSheetList, Boolean readAll) {
        this.readSheetList = readSheetList;
        this.readAll = readAll;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

