/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.transformlet.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);

    @NonNull
    static String signatureOfMethod(@NonNull CtBehavior method) throws NotFoundException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Modifier.toString(method.getModifiers()));
        if (method instanceof CtMethod) {
            String returnType = ((CtMethod)method).getReturnType().getSimpleName();
            stringBuilder.append(" ").append(returnType);
        }
        stringBuilder.append(" ").append(method.getName()).append("(");
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            CtClass parameterType = parameterTypes[i];
            if (i != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameterType.getSimpleName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @NonNull
    static String renamedMethodNameByTtl(@NonNull CtMethod method) {
        return "original$" + method.getName() + "$method$renamed$by$ttl";
    }

    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        Utils.doTryFinallyForMethod(method, Utils.renamedMethodNameByTtl(method), beforeCode, finallyCode);
    }

    static void doTryFinallyForMethod(@NonNull CtMethod method, @NonNull String renamedMethodName, @NonNull String beforeCode, @NonNull String finallyCode) throws CannotCompileException, NotFoundException {
        CtClass clazz = method.getDeclaringClass();
        CtMethod newMethod = CtNewMethod.copy(method, clazz, null);
        method.setName(renamedMethodName);
        method.setModifiers(method.getModifiers() & 0xFFFFFFFE & 0xFFFFFFFB | 2);
        String returnOp = method.getReturnType() == CtClass.voidType ? "" : "return ";
        String code = "{\n" + beforeCode + "\ntry {\n    " + returnOp + renamedMethodName + "($$);\n} finally {\n    " + finallyCode + "\n} }";
        newMethod.setBody(code);
        clazz.addMethod(newMethod);
        logger.info("insert code around method " + Utils.signatureOfMethod(newMethod) + " of class " + clazz.getName() + ": " + code);
    }

    @Nullable
    public static Object doCaptureWhenNotTtlEnhanced(@Nullable Object obj) {
        if (obj instanceof TtlEnhanced) {
            return null;
        }
        return TransmittableThreadLocal.Transmitter.capture();
    }

    @Nullable
    public static Runnable doAutoWrap(@Nullable Runnable runnable) {
        if (runnable == null) {
            return null;
        }
        TtlRunnable ret = TtlRunnable.get(runnable, false, true);
        if (ret != runnable) {
            Utils.setAutoWrapperAttachment(ret);
        }
        return ret;
    }

    @Nullable
    public static <T> Callable<T> doAutoWrap(@Nullable Callable<T> callable) {
        if (callable == null) {
            return null;
        }
        TtlCallable<T> ret = TtlCallable.get(callable, false, true);
        if (ret != callable) {
            Utils.setAutoWrapperAttachment(ret);
        }
        return ret;
    }

    private static void setAutoWrapperAttachment(@Nullable Object ttlAttachment) {
        if (!(ttlAttachment instanceof TtlAttachments)) {
            return;
        }
        ((TtlAttachments)ttlAttachment).setTtlAttachment("ttl.is.auto.wrapper", true);
    }

    @Nullable
    public static Runnable doUnwrapIfIsAutoWrapper(@Nullable Runnable runnable) {
        if (!(runnable instanceof TtlAttachments)) {
            return runnable;
        }
        Boolean isAutoWrapper = (Boolean)((TtlAttachments)((Object)runnable)).getTtlAttachment("ttl.is.auto.wrapper");
        if (!Boolean.TRUE.equals(isAutoWrapper)) {
            return runnable;
        }
        return TtlRunnable.unwrap(runnable);
    }

    @NonNull
    public static String getPackageName(@NonNull String className) {
        int idx = className.lastIndexOf(46);
        if (-1 == idx) {
            return "";
        }
        return className.substring(0, idx);
    }

    public static boolean isClassAtPackage(@NonNull String className, @NonNull String packageName) {
        return packageName.equals(Utils.getPackageName(className));
    }

    public static boolean isClassUnderPackage(@NonNull String className, @NonNull String packageName) {
        String packageOfClass = Utils.getPackageName(className);
        return packageOfClass.equals(packageName) || packageOfClass.startsWith(packageName + ".");
    }

    public static boolean isClassAtPackageJavaUtil(@NonNull String className) {
        return Utils.isClassAtPackage(className, "java.util");
    }
}

