/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.transform.AlarmStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.StepAdjustmentStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ScalingPolicyStaxUnmarshaller
implements Unmarshaller<ScalingPolicy, StaxUnmarshallerContext> {
    private static ScalingPolicyStaxUnmarshaller instance;

    public ScalingPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        ScalingPolicy scalingPolicy = new ScalingPolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return scalingPolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    scalingPolicy.setAutoScalingGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyName", targetDepth)) {
                    scalingPolicy.setPolicyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyARN", targetDepth)) {
                    scalingPolicy.setPolicyARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyType", targetDepth)) {
                    scalingPolicy.setPolicyType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdjustmentType", targetDepth)) {
                    scalingPolicy.setAdjustmentType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinAdjustmentStep", targetDepth)) {
                    scalingPolicy.setMinAdjustmentStep(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinAdjustmentMagnitude", targetDepth)) {
                    scalingPolicy.setMinAdjustmentMagnitude(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ScalingAdjustment", targetDepth)) {
                    scalingPolicy.setScalingAdjustment(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Cooldown", targetDepth)) {
                    scalingPolicy.setCooldown(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StepAdjustments", targetDepth)) {
                    scalingPolicy.withStepAdjustments(new ArrayList<StepAdjustment>());
                    continue;
                }
                if (context.testExpression("StepAdjustments/member", targetDepth)) {
                    scalingPolicy.withStepAdjustments(StepAdjustmentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricAggregationType", targetDepth)) {
                    scalingPolicy.setMetricAggregationType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EstimatedInstanceWarmup", targetDepth)) {
                    scalingPolicy.setEstimatedInstanceWarmup(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Alarms", targetDepth)) {
                    scalingPolicy.withAlarms(new ArrayList<Alarm>());
                    continue;
                }
                if (!context.testExpression("Alarms/member", targetDepth)) continue;
                scalingPolicy.withAlarms(AlarmStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return scalingPolicy;
    }

    public static ScalingPolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingPolicyStaxUnmarshaller();
        }
        return instance;
    }
}

