/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bvw;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bvw.BvwErrorResponseHandler;
import com.baidubce.services.bvw.BvwMetadataResponseHandler;
import com.baidubce.services.bvw.model.common.ListByPageResponse;
import com.baidubce.services.bvw.model.matlib.MaterialBaseResponse;
import com.baidubce.services.bvw.model.matlib.MaterialGetRequest;
import com.baidubce.services.bvw.model.matlib.MaterialGetResponse;
import com.baidubce.services.bvw.model.matlib.MaterialPresetGetRequest;
import com.baidubce.services.bvw.model.matlib.MaterialPresetGetResponse;
import com.baidubce.services.bvw.model.matlib.MaterialPresetSearchRequest;
import com.baidubce.services.bvw.model.matlib.MaterialPresetSearchResponse;
import com.baidubce.services.bvw.model.matlib.MaterialPresetUploadResponse;
import com.baidubce.services.bvw.model.matlib.MaterialSearchRequest;
import com.baidubce.services.bvw.model.matlib.MaterialSearchResponse;
import com.baidubce.services.bvw.model.matlib.MatlibConfigBaseRequest;
import com.baidubce.services.bvw.model.matlib.MatlibConfigBaseResponse;
import com.baidubce.services.bvw.model.matlib.MatlibConfigGetResponse;
import com.baidubce.services.bvw.model.matlib.MatlibUploadRequest;
import com.baidubce.services.bvw.model.matlib.MatlibUploadResponse;
import com.baidubce.services.bvw.model.matlib.Text2AudioRequest;
import com.baidubce.services.bvw.model.matlib.Text2AudioResponse;
import com.baidubce.services.bvw.model.matlib.VideoGenerationRequest;
import com.baidubce.services.bvw.model.matlib.VideoGenerationResponse;
import com.baidubce.services.bvw.model.media.MediaBaseRequest;
import com.baidubce.services.bvw.model.media.MediaBaseResponse;
import com.baidubce.services.bvw.model.media.MediaBatchDeleteRequest;
import com.baidubce.services.bvw.model.media.MediaGetResponse;
import com.baidubce.services.bvw.model.media.MediaInstanceListResponse;
import com.baidubce.services.bvw.model.media.MediaListRequest;
import com.baidubce.services.bvw.model.media.MediaListResponse;
import com.baidubce.services.bvw.model.media.MediaProcessRequest;
import com.baidubce.services.bvw.model.media.MediaProcessResponse;
import com.baidubce.services.bvw.model.media.MediaUpdateRequest;
import com.baidubce.services.bvw.model.notification.AuthType;
import com.baidubce.services.bvw.model.notification.NotificationBaseRequest;
import com.baidubce.services.bvw.model.notification.NotificationBaseResponse;
import com.baidubce.services.bvw.model.notification.NotificationCreateRequest;
import com.baidubce.services.bvw.model.notification.NotificationGetResponse;
import com.baidubce.services.bvw.model.notification.NotificationListRequest;
import com.baidubce.services.bvw.model.notification.NotificationListResponse;
import com.baidubce.services.bvw.model.notification.NotificationStatus;
import com.baidubce.services.bvw.model.notification.NotificationUpdateRequest;
import com.baidubce.services.bvw.model.videoedit.VideoEditCreateRequest;
import com.baidubce.services.bvw.model.videoedit.VideoEditCreateResponse;
import com.baidubce.services.bvw.model.videoedit.VideoEditPollingRequest;
import com.baidubce.services.bvw.model.videoedit.VideoEditPollingResponse;
import com.baidubce.services.bvw.model.workflow.WorkflowBaseRequest;
import com.baidubce.services.bvw.model.workflow.WorkflowBaseResponse;
import com.baidubce.services.bvw.model.workflow.WorkflowCreateRequest;
import com.baidubce.services.bvw.model.workflow.WorkflowGetResponse;
import com.baidubce.services.bvw.model.workflow.WorkflowListRequest;
import com.baidubce.services.bvw.model.workflow.WorkflowListResponse;
import com.baidubce.services.bvw.model.workflow.WorkflowUpdateRequest;
import com.baidubce.services.bvw.model.workflow.instance.InstanceBaseRequest;
import com.baidubce.services.bvw.model.workflow.instance.InstanceGetResponse;
import com.baidubce.services.bvw.model.workflow.instance.InstanceGetTaskUrlsResponse;
import com.baidubce.services.bvw.model.workflow.task.TaskBaseRequest;
import com.baidubce.services.bvw.model.workflow.task.TaskGetResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BvwClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String WORKFLOW = "workflow";
    private static final String MEDIA = "media";
    private static final String INSTANCE = "instance";
    private static final String TASK = "task";
    private static final String NOTIFICATION = "notification";
    private static final String MATLIB = "matlib";
    private static final String MATERIAL_LIBRARY = "materialLibrary";
    private static final String MATERIAL_LIBRARY_PRESET = "preset";
    private static final String MATLIB_VIDEO_GENERATION = "videoGenerationTask";
    private static final String VIDEO_EDIT = "videoEdit";
    private static final String VIDEO_EDIT_CREATE = "createNewVideo";
    private static final String VIDEO_EDIT_POLLING = "pollingVideo";
    private static final String LIST_PAGE_NO = "pageNo";
    private static final String LIST_PAGE_SIZE = "pageSize";
    private static final String LIST_BEGIN_TIME = "beginTime";
    private static final String LIST_END_TIME = "endTime";
    private static final String WORKFLOW_LIST_STATUS = "status";
    private static final String WORKFLOW_LIST_NAME = "name";
    private static final String WORKFLOW_ENABLE = "enable";
    private static final String WORKFLOW_DISABLE = "disable";
    private static final String MEDIA_PROCESS = "process";
    private static final String MEDIA_INSTANCES = "queryMediaInstanceList";
    private static final String MEDIA_BAN = "ban";
    private static final String MEDIA_UNBAN = "unban";
    private static final String MEDIA_LIST_STATUS = "status";
    private static final String MEDIA_LIST_INSTANCE_STATUS = "instanceStatus";
    private static final String MEDIA_LIST_MEDIA_ID = "mediaId";
    private static final String MEDIA_LIST_TITLE = "title";
    private static final String MEDIA_LIST_ORDER = "order";
    private static final String MEDIA_LIST_ORDER_BY = "orderBy";
    private static final String MEDIA_BATCH_DELETE = "mediaIds";
    private static final String INSTANCE_TASK_URLS = "queryStageTaskUrlList";
    private static final String NOTIFICATION_LIST_STATUS = "status";
    private static final String NOTIFICATION_ENABLE = "enable";
    private static final String NOTIFICATION_DISABLE = "disable";
    private static final String MATLIB_UPLOAD = "upload";
    private static final String MATLIB_CONFIG = "config";
    private static final String MATLIB_SPEECH = "speech";
    private static final String MATERIAL_TITLE_KEYWORD = "titleKeyword";
    private static final String MATERIAL_PRESET_TYPE = "type";
    private static final String MATERIAL_SOURCE_TYPE = "sourceType";
    private static final String MATERIAL_INFO_TYPE = "infoType";
    private static final String MATERIAL_MEDIA_TYPE = "mediaType";
    private static final String MATERIAL_STATUS = "status";
    private static final String MATERIAL_CREATETIME_BEGIN = "begin";
    private static final String MATERIAL_CREATETIME_END = "end";
    private static final String MATERIAL_PAGENO = "pageNo";
    private static final String MATERIAL_SIZE = "size";
    private static final String MATERIAL_PAGESIZE = "pageSize";
    private static final HttpResponseHandler[] BVW_HANDLES = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BvwMetadataResponseHandler(), new BvwErrorResponseHandler(), new BceJsonResponseHandler()};

    public BvwClient(BceClientConfiguration config) {
        super(config, BVW_HANDLES, true);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillPayload(request, bceRequest);
        }
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(bceRequest);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public WorkflowBaseResponse createWorkflow(WorkflowCreateRequest workflowCreateRequest) {
        InternalRequest request = this.createRequest(workflowCreateRequest, HttpMethodName.POST, WORKFLOW);
        return this.invokeHttpClient(request, WorkflowBaseResponse.class);
    }

    public WorkflowGetResponse getWorkflow(String workflowName) {
        WorkflowBaseRequest getRequest = WorkflowBaseRequest.of(workflowName);
        return this.getWorkflow(getRequest);
    }

    public WorkflowGetResponse getWorkflow(WorkflowBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, WORKFLOW, getRequest.getName());
        return this.invokeHttpClient(request, WorkflowGetResponse.class);
    }

    public WorkflowBaseResponse deleteWorkflow(String workflowName) {
        WorkflowBaseRequest deleteRequest = WorkflowBaseRequest.of(workflowName);
        return this.deleteWorkflow(deleteRequest);
    }

    public WorkflowBaseResponse deleteWorkflow(WorkflowBaseRequest deleteRequest) {
        InternalRequest request = this.createRequest(deleteRequest, HttpMethodName.DELETE, WORKFLOW, deleteRequest.getName());
        return this.invokeHttpClient(request, WorkflowBaseResponse.class);
    }

    public WorkflowBaseResponse updateWorkflow(WorkflowUpdateRequest updateRequest) {
        InternalRequest request = this.createRequest(updateRequest, HttpMethodName.PUT, WORKFLOW, updateRequest.getName());
        return this.invokeHttpClient(request, WorkflowBaseResponse.class);
    }

    public ListByPageResponse<WorkflowListResponse> listWorkflow(WorkflowListRequest listRequest) {
        InternalRequest request = this.createRequest(listRequest, HttpMethodName.GET, WORKFLOW);
        request.addParameter("pageNo", String.valueOf(listRequest.getPageNo()));
        request.addParameter("pageSize", String.valueOf(listRequest.getPageSize()));
        if (null != listRequest.getStatus()) {
            request.addParameter("status", String.valueOf((Object)listRequest.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getBeginTime())) {
            request.addParameter(LIST_BEGIN_TIME, listRequest.getBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getEndTime())) {
            request.addParameter(LIST_END_TIME, listRequest.getEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getName())) {
            request.addParameter(WORKFLOW_LIST_NAME, listRequest.getName());
        }
        return this.invokeHttpClient(request, ListByPageResponse.class);
    }

    public WorkflowBaseResponse enableWorkflow(WorkflowBaseRequest enableRequest) {
        InternalRequest request = this.createRequest(enableRequest, HttpMethodName.PUT, WORKFLOW, enableRequest.getName());
        request.addParameter("enable", null);
        return this.invokeHttpClient(request, WorkflowBaseResponse.class);
    }

    public WorkflowBaseResponse enableWorkflow(String workflowName) {
        WorkflowBaseRequest enableRequest = WorkflowBaseRequest.of(workflowName);
        return this.enableWorkflow(enableRequest);
    }

    public WorkflowBaseResponse disableWorkflow(WorkflowBaseRequest disableRequest) {
        InternalRequest request = this.createRequest(disableRequest, HttpMethodName.PUT, WORKFLOW, disableRequest.getName());
        request.addParameter("disable", null);
        return this.invokeHttpClient(request, WorkflowBaseResponse.class);
    }

    public WorkflowBaseResponse disableWorkflow(String workflowName) {
        WorkflowBaseRequest disableRequest = WorkflowBaseRequest.of(workflowName);
        return this.disableWorkflow(disableRequest);
    }

    public MediaProcessResponse processMedia(MediaProcessRequest processRequest) {
        InternalRequest request = this.createRequest(processRequest, HttpMethodName.POST, MEDIA);
        request.addParameter(MEDIA_PROCESS, null);
        return this.invokeHttpClient(request, MediaProcessResponse.class);
    }

    public MediaGetResponse getMedia(MediaBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, MEDIA, getRequest.getMediaId());
        return this.invokeHttpClient(request, MediaGetResponse.class);
    }

    public MediaGetResponse getMedia(String mediaId) {
        MediaBaseRequest getRequest = MediaBaseRequest.of(mediaId);
        return this.getMedia(getRequest);
    }

    public MediaBaseResponse updateMedia(MediaUpdateRequest updateRequest) {
        InternalRequest request = this.createRequest(updateRequest, HttpMethodName.PUT, MEDIA, updateRequest.getMediaId());
        return this.invokeHttpClient(request, MediaBaseResponse.class);
    }

    public MediaInstanceListResponse getMediaInstanceList(MediaBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, MEDIA, getRequest.getMediaId());
        request.addParameter(MEDIA_INSTANCES, null);
        return this.invokeHttpClient(request, MediaInstanceListResponse.class);
    }

    public MediaInstanceListResponse getMediaInstanceList(String mediaId) {
        MediaBaseRequest getRequest = MediaBaseRequest.of(mediaId);
        return this.getMediaInstanceList(getRequest);
    }

    public MediaBaseResponse banMedia(MediaBaseRequest banRequest) {
        InternalRequest request = this.createRequest(banRequest, HttpMethodName.PUT, MEDIA, banRequest.getMediaId());
        request.addParameter(MEDIA_BAN, null);
        return this.invokeHttpClient(request, MediaBaseResponse.class);
    }

    public MediaBaseResponse banMedia(String mediaId) {
        MediaBaseRequest banRequest = MediaBaseRequest.of(mediaId);
        return this.banMedia(banRequest);
    }

    public MediaBaseResponse unbanMedia(MediaBaseRequest unbanRequest) {
        InternalRequest request = this.createRequest(unbanRequest, HttpMethodName.PUT, MEDIA, unbanRequest.getMediaId());
        request.addParameter(MEDIA_UNBAN, null);
        return this.invokeHttpClient(request, MediaBaseResponse.class);
    }

    public MediaBaseResponse unbanMedia(String mediaId) {
        MediaBaseRequest unbanRequest = MediaBaseRequest.of(mediaId);
        return this.unbanMedia(unbanRequest);
    }

    public ListByPageResponse<MediaListResponse> listMedia(MediaListRequest listRequest) {
        InternalRequest request = this.createRequest(listRequest, HttpMethodName.GET, MEDIA);
        request.addParameter("pageNo", String.valueOf(listRequest.getPageNo()));
        request.addParameter("pageSize", String.valueOf(listRequest.getPageSize()));
        if (StringUtils.isNotBlank((CharSequence)listRequest.getBeginTime())) {
            request.addParameter(LIST_BEGIN_TIME, listRequest.getBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getEndTime())) {
            request.addParameter(LIST_END_TIME, listRequest.getEndTime());
        }
        if (null != listRequest.getStatus()) {
            request.addParameter("status", String.valueOf((Object)listRequest.getStatus()));
        }
        if (null != listRequest.getInstanceStatus()) {
            request.addParameter(MEDIA_LIST_INSTANCE_STATUS, String.valueOf((Object)listRequest.getInstanceStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getMediaId())) {
            request.addParameter(MEDIA_LIST_MEDIA_ID, listRequest.getMediaId());
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getTitle())) {
            request.addParameter(MEDIA_LIST_TITLE, listRequest.getTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)listRequest.getOrder()) && StringUtils.isNotBlank((CharSequence)listRequest.getOrderBy())) {
            request.addParameter(MEDIA_LIST_ORDER, listRequest.getOrder());
            request.addParameter(MEDIA_LIST_ORDER_BY, listRequest.getOrderBy());
        }
        return this.invokeHttpClient(request, ListByPageResponse.class);
    }

    public MediaBaseResponse deleteMedia(MediaBaseRequest deleteRequest) {
        InternalRequest request = this.createRequest(deleteRequest, HttpMethodName.DELETE, MEDIA, deleteRequest.getMediaId());
        return this.invokeHttpClient(request, MediaBaseResponse.class);
    }

    public MediaBaseResponse deleteMedia(String mediaId) {
        MediaBaseRequest deleteRequest = MediaBaseRequest.of(mediaId);
        return this.deleteMedia(deleteRequest);
    }

    public MediaBaseResponse batchDeleteMedia(MediaBatchDeleteRequest batchDeleteRequest) {
        InternalRequest request = this.createRequest(batchDeleteRequest, HttpMethodName.DELETE, MEDIA);
        if (StringUtils.isNotBlank((CharSequence)batchDeleteRequest.getMediaIds())) {
            request.addParameter(MEDIA_BATCH_DELETE, batchDeleteRequest.getMediaIds());
        }
        return this.invokeHttpClient(request, MediaBaseResponse.class);
    }

    public MediaBaseResponse batchDeleteMedia(List<String> mediaIds) {
        MediaBatchDeleteRequest batchDeleteRequest = MediaBatchDeleteRequest.of(mediaIds);
        return this.batchDeleteMedia(batchDeleteRequest);
    }

    public InstanceGetResponse getInstance(InstanceBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, INSTANCE, getRequest.getInstanceId());
        return this.invokeHttpClient(request, InstanceGetResponse.class);
    }

    public InstanceGetResponse getInstance(String instanceId) {
        InstanceBaseRequest getRequest = InstanceBaseRequest.of(instanceId);
        return this.getInstance(getRequest);
    }

    public InstanceGetTaskUrlsResponse getInstanceTaskUrls(InstanceBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, INSTANCE, getRequest.getInstanceId());
        request.addParameter(INSTANCE_TASK_URLS, null);
        return this.invokeHttpClient(request, InstanceGetTaskUrlsResponse.class);
    }

    public InstanceGetTaskUrlsResponse getInstanceTaskUrls(String instanceId) {
        InstanceBaseRequest getRequest = InstanceBaseRequest.of(instanceId);
        return this.getInstanceTaskUrls(getRequest);
    }

    public TaskGetResponse getTask(TaskBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, TASK, getRequest.getTaskId());
        return this.invokeHttpClient(request, TaskGetResponse.class);
    }

    public TaskGetResponse getTask(String taskId) {
        TaskBaseRequest getRequest = TaskBaseRequest.of(taskId);
        return this.getTask(getRequest);
    }

    public NotificationBaseResponse createNotification(NotificationCreateRequest createRequest) {
        InternalRequest request = this.createRequest(createRequest, HttpMethodName.POST, NOTIFICATION);
        return this.invokeHttpClient(request, NotificationBaseResponse.class);
    }

    public NotificationBaseResponse createNotification(String name, String endpoint) {
        NotificationCreateRequest createRequest = NotificationCreateRequest.of(name, endpoint);
        return this.createNotification(createRequest);
    }

    public NotificationBaseResponse createNotification(String name, String endpoint, String token, AuthType authType) {
        NotificationCreateRequest createRequest = NotificationCreateRequest.of(name, endpoint, token, authType);
        return this.createNotification(createRequest);
    }

    public NotificationGetResponse getNotification(NotificationBaseRequest getRequest) {
        InternalRequest request = this.createRequest(getRequest, HttpMethodName.GET, NOTIFICATION, getRequest.getName());
        return this.invokeHttpClient(request, NotificationGetResponse.class);
    }

    public NotificationGetResponse getNotification(String name) {
        NotificationBaseRequest getRequest = NotificationBaseRequest.of(name);
        return this.getNotification(getRequest);
    }

    public NotificationListResponse listNotification(NotificationListRequest listRequest) {
        InternalRequest request = this.createRequest(listRequest, HttpMethodName.GET, NOTIFICATION);
        if (null != listRequest.getStatus()) {
            request.addParameter("status", String.valueOf((Object)listRequest.getStatus()));
        }
        return this.invokeHttpClient(request, NotificationListResponse.class);
    }

    public NotificationListResponse listNotification(NotificationStatus status) {
        NotificationListRequest listRequest = NotificationListRequest.of(status);
        return this.listNotification(listRequest);
    }

    public NotificationListResponse listNotification() {
        NotificationListRequest listRequest = NotificationListRequest.of(null);
        return this.listNotification(listRequest);
    }

    public NotificationBaseResponse updateNotification(NotificationUpdateRequest updateRequest) {
        InternalRequest request = this.createRequest(updateRequest, HttpMethodName.PUT, NOTIFICATION, updateRequest.getName());
        return this.invokeHttpClient(request, NotificationBaseResponse.class);
    }

    public NotificationBaseResponse updateNotification(String name, String endpoint) {
        NotificationUpdateRequest updateRequest = NotificationUpdateRequest.of(name, endpoint);
        return this.updateNotification(updateRequest);
    }

    public NotificationBaseResponse updateNotification(String name, String endpoint, String token, AuthType authType) {
        NotificationUpdateRequest updateRequest = NotificationUpdateRequest.of(name, endpoint, token, authType);
        return this.updateNotification(updateRequest);
    }

    public NotificationBaseResponse enableNotification(NotificationBaseRequest enableRequest) {
        InternalRequest request = this.createRequest(enableRequest, HttpMethodName.PUT, NOTIFICATION, enableRequest.getName());
        request.addParameter("enable", null);
        return this.invokeHttpClient(request, NotificationBaseResponse.class);
    }

    public NotificationBaseResponse enableNotification(String name) {
        NotificationBaseRequest enableRequest = NotificationBaseRequest.of(name);
        return this.enableNotification(enableRequest);
    }

    public NotificationBaseResponse disableNotification(NotificationBaseRequest disableRequest) {
        InternalRequest request = this.createRequest(disableRequest, HttpMethodName.PUT, NOTIFICATION, disableRequest.getName());
        request.addParameter("disable", null);
        return this.invokeHttpClient(request, NotificationBaseResponse.class);
    }

    public NotificationBaseResponse disableNotification(String name) {
        NotificationBaseRequest disableRequest = NotificationBaseRequest.of(name);
        return this.disableNotification(disableRequest);
    }

    public NotificationBaseResponse deleteNotification(NotificationBaseRequest deleteRequest) {
        InternalRequest request = this.createRequest(deleteRequest, HttpMethodName.DELETE, NOTIFICATION, deleteRequest.getName());
        return this.invokeHttpClient(request, NotificationBaseResponse.class);
    }

    public NotificationBaseResponse deleteNotification(String name) {
        NotificationBaseRequest deleteRequest = NotificationBaseRequest.of(name);
        return this.deleteNotification(deleteRequest);
    }

    public MatlibUploadResponse upload2Material(MatlibUploadRequest matlibUploadRequest) {
        InternalRequest request = this.createRequest(matlibUploadRequest, HttpMethodName.POST, MATLIB);
        request.addParameter(MATLIB_UPLOAD, null);
        return this.invokeHttpClient(request, MatlibUploadResponse.class);
    }

    public MaterialGetResponse getMaterial(String materialId) {
        MaterialGetRequest materialGetRequest = new MaterialGetRequest(materialId);
        InternalRequest request = this.createRequest(materialGetRequest, HttpMethodName.GET, MATERIAL_LIBRARY, materialId);
        return this.invokeHttpClient(request, MaterialGetResponse.class);
    }

    public MaterialBaseResponse deleteMaterial(String materialId) {
        MaterialGetRequest materialGetRequest = new MaterialGetRequest(materialId);
        InternalRequest request = this.createRequest(materialGetRequest, HttpMethodName.DELETE, MATERIAL_LIBRARY, materialId);
        return this.invokeHttpClient(request, MaterialBaseResponse.class);
    }

    public MaterialSearchResponse searchMaterial(MaterialSearchRequest materialSearchRequest) {
        InternalRequest request = this.createRequest(materialSearchRequest, HttpMethodName.GET, MATERIAL_LIBRARY);
        if (null != materialSearchRequest.getInfoType()) {
            request.addParameter(MATERIAL_INFO_TYPE, materialSearchRequest.getInfoType());
        }
        if (null != materialSearchRequest.getMediaType()) {
            request.addParameter(MATERIAL_MEDIA_TYPE, materialSearchRequest.getMediaType());
        }
        if (null != materialSearchRequest.getSourceType()) {
            request.addParameter(MATERIAL_SOURCE_TYPE, materialSearchRequest.getSourceType());
        }
        if (null != materialSearchRequest.getStatus()) {
            request.addParameter("status", materialSearchRequest.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)materialSearchRequest.getTitleKeyword())) {
            request.addParameter(MATERIAL_TITLE_KEYWORD, materialSearchRequest.getTitleKeyword());
        }
        if (null != materialSearchRequest.getBegin()) {
            request.addParameter(MATERIAL_CREATETIME_BEGIN, materialSearchRequest.getBegin());
        }
        if (null != materialSearchRequest.getEnd()) {
            request.addParameter(MATERIAL_CREATETIME_END, materialSearchRequest.getEnd());
        }
        if (null != materialSearchRequest.getPageNo()) {
            request.addParameter("pageNo", materialSearchRequest.getPageNo() + "");
        }
        if (null != materialSearchRequest.getSize()) {
            request.addParameter(MATERIAL_SIZE, materialSearchRequest.getSize() + "");
        }
        return this.invokeHttpClient(request, MaterialSearchResponse.class);
    }

    public MaterialPresetUploadResponse uploadMaterialPreset(String type, MatlibUploadRequest matlibUploadRequest) {
        InternalRequest request = this.createRequest(matlibUploadRequest, HttpMethodName.POST, MATERIAL_LIBRARY, MATERIAL_LIBRARY_PRESET, type);
        request.addParameter(MATLIB_UPLOAD, null);
        return this.invokeHttpClient(request, MaterialPresetUploadResponse.class);
    }

    public MaterialPresetGetResponse getMaterialPreset(String id) {
        MaterialPresetGetRequest materialPresetGetRequest = new MaterialPresetGetRequest(id);
        InternalRequest request = this.createRequest(materialPresetGetRequest, HttpMethodName.GET, MATERIAL_LIBRARY, MATERIAL_LIBRARY_PRESET, id);
        return this.invokeHttpClient(request, MaterialPresetGetResponse.class);
    }

    public MaterialBaseResponse deleteMaterialPreset(String id) {
        MaterialPresetGetRequest materialPresetGetRequest = new MaterialPresetGetRequest(id);
        InternalRequest request = this.createRequest(materialPresetGetRequest, HttpMethodName.DELETE, MATERIAL_LIBRARY, MATERIAL_LIBRARY_PRESET, id);
        return this.invokeHttpClient(request, MaterialBaseResponse.class);
    }

    public MaterialPresetSearchResponse searchMaterialPreset(MaterialPresetSearchRequest materialPresetSearchRequest) {
        InternalRequest request = this.createRequest(materialPresetSearchRequest, HttpMethodName.GET, MATERIAL_LIBRARY, MATERIAL_LIBRARY_PRESET);
        if (null != materialPresetSearchRequest.getSourceType()) {
            request.addParameter(MATERIAL_SOURCE_TYPE, materialPresetSearchRequest.getSourceType());
        }
        if (null != materialPresetSearchRequest.getStatus()) {
            request.addParameter("status", materialPresetSearchRequest.getStatus());
        }
        if (null != materialPresetSearchRequest.getType()) {
            request.addParameter(MATERIAL_PRESET_TYPE, materialPresetSearchRequest.getType());
        }
        if (null != materialPresetSearchRequest.getPageNo()) {
            request.addParameter("pageNo", materialPresetSearchRequest.getPageNo() + "");
        }
        if (null != materialPresetSearchRequest.getPageSize()) {
            request.addParameter("pageSize", materialPresetSearchRequest.getPageSize() + "");
        }
        return this.invokeHttpClient(request, MaterialPresetSearchResponse.class);
    }

    public MatlibConfigBaseResponse createMatlibConfig(MatlibConfigBaseRequest baseRequest) {
        InternalRequest request = this.createRequest(baseRequest, HttpMethodName.POST, MATLIB, MATLIB_CONFIG);
        return this.invokeHttpClient(request, MatlibConfigBaseResponse.class);
    }

    public MatlibConfigBaseResponse updateMatlibConfig(MatlibConfigBaseRequest baseRequest) {
        InternalRequest request = this.createRequest(baseRequest, HttpMethodName.PUT, MATLIB, MATLIB_CONFIG);
        return this.invokeHttpClient(request, MatlibConfigBaseResponse.class);
    }

    public MatlibConfigGetResponse getMatlibConfig() {
        InternalRequest request = this.createRequest(new MatlibConfigBaseRequest(), HttpMethodName.GET, MATLIB, MATLIB_CONFIG);
        return this.invokeHttpClient(request, MatlibConfigGetResponse.class);
    }

    public Text2AudioResponse text2Audio(Text2AudioRequest text2AudioRequest) {
        InternalRequest request = this.createRequest(text2AudioRequest, HttpMethodName.POST, MATLIB, MATLIB_SPEECH);
        return this.invokeHttpClient(request, Text2AudioResponse.class);
    }

    public VideoEditCreateResponse createVideoEdit(VideoEditCreateRequest videoEditCreateRequest) {
        InternalRequest request = this.createRequest(videoEditCreateRequest, HttpMethodName.POST, VIDEO_EDIT, VIDEO_EDIT_CREATE);
        return this.invokeHttpClient(request, VideoEditCreateResponse.class);
    }

    public VideoEditPollingResponse pollingVideoEdit(long editId) {
        VideoEditPollingRequest videoEditPollingRequest = new VideoEditPollingRequest(editId);
        InternalRequest request = this.createRequest(videoEditPollingRequest, HttpMethodName.GET, VIDEO_EDIT, VIDEO_EDIT_POLLING, String.format("%d", editId));
        return this.invokeHttpClient(request, VideoEditPollingResponse.class);
    }

    public VideoGenerationResponse createVideoGenerationTask(VideoGenerationRequest videoGenerationRequest) {
        InternalRequest request = this.createRequest(videoGenerationRequest, HttpMethodName.POST, MATLIB, MATLIB_VIDEO_GENERATION);
        return this.invokeHttpClient(request, VideoGenerationResponse.class);
    }
}

