/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.ShowTableResponse;
import com.baidubce.services.tablestorage.model.TableState;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;

public class ShowTableResponseUnmarshaller
implements Unmarshaller<ShowTableResponse, InputStream> {
    private ShowTableResponse result;

    public ShowTableResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (ShowTableResponse)response;
    }

    @Override
    public ShowTableResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        String instanceName = root.get("instance").asText();
        String tableName = root.get("tableName").asText();
        String state = root.get("tableState").asText();
        long version = root.get("tableVersion").asLong();
        String createTime = root.get("createTime").asText();
        String compressType = root.get("compressType").asText();
        int ttl = root.get("ttl").asInt();
        String storageType = root.get("storageType").asText();
        int maxVersions = root.has("maxVersions") ? root.get("maxVersions").asInt() : 1;
        this.result.setInstanceName(instanceName);
        this.result.setTableName(tableName);
        this.result.setTableState(TableState.valueOf(state));
        this.result.setTableVersion(version);
        this.result.setCreateTime(createTime);
        this.result.setCompressType(CompressType.valueOf(compressType));
        this.result.setTimeToLive(ttl);
        this.result.setStorageType(storageType);
        this.result.setMaxVersions(maxVersions);
        return this.result;
    }
}

