/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.converter.xml.jaxb;

import com.dtflys.forest.converter.ConvertOptions;
import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.converter.xml.ForestXmlConverter;
import com.dtflys.forest.exceptions.ForestConvertException;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestBody;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ForestJaxbConverter
implements ForestXmlConverter {
    private static final Map<Class<?>, JAXBContext> JAXB_CONTEXT_CACHE = new ConcurrentHashMap();

    private JAXBContext getJAXBContext(Class<?> clazz) {
        JAXBContext jaxbContext = JAXB_CONTEXT_CACHE.get(clazz);
        if (jaxbContext != null) {
            return jaxbContext;
        }
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException e) {
            throw new ForestConvertException((ForestConverter)this, (Throwable)e);
        }
        JAXB_CONTEXT_CACHE.put(clazz, jaxbContext);
        return jaxbContext;
    }

    public String encodeToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj instanceof Map || obj instanceof List) {
            throw new ForestRuntimeException("[Forest] JAXB XML converter dose not support translating instance of java.util.Map or java.util.List");
        }
        try {
            JAXBContext jaxbContext = this.getJAXBContext(obj.getClass());
            StringWriter writer = new StringWriter();
            this.createMarshaller(jaxbContext, "UTF-8").marshal(obj, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new ForestConvertException((ForestConverter)this, (Throwable)e);
        }
    }

    public byte[] encodeRequestBody(ForestBody body, Charset charset, ConvertOptions options) {
        StringBuilder builder = new StringBuilder();
        for (ForestRequestBody item : body) {
            if (item instanceof ObjectRequestBody) {
                Object obj = ((ObjectRequestBody)item).getObject();
                String text = this.encodeToString(obj);
                builder.append(text);
                continue;
            }
            if (!(item instanceof StringRequestBody)) continue;
            builder.append(((StringRequestBody)item).getContent());
        }
        return builder.toString().getBytes(charset);
    }

    public <T> T convertToJavaObject(String source, Class<T> targetType) {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = this.getJAXBContext(targetType);
            StringReader reader = new StringReader(source);
            return (T)this.createUnmarshaller(jaxbContext).unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new ForestConvertException((ForestConverter)this, (Throwable)e);
        }
    }

    public <T> T convertToJavaObject(String source, Type targetType) {
        Class clazz = ReflectUtils.toClass((Type)targetType);
        return this.convertToJavaObject(source, clazz);
    }

    public <T> T convertToJavaObject(byte[] source, Class<T> targetType, Charset charset) {
        String str = StringUtils.fromBytes((byte[])source, (Charset)charset);
        return this.convertToJavaObject(str, targetType);
    }

    public <T> T convertToJavaObject(byte[] source, Type targetType, Charset charset) {
        Class clazz = ReflectUtils.toClass((Type)targetType);
        return this.convertToJavaObject(source, clazz, charset);
    }

    public Marshaller createMarshaller(JAXBContext jaxbContext, String encoding) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (StringUtils.isNotEmpty((CharSequence)encoding)) {
                marshaller.setProperty("jaxb.encoding", (Object)encoding);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new ForestRuntimeException((Throwable)e);
        }
    }

    public Unmarshaller createUnmarshaller(JAXBContext jaxbContext) {
        try {
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public ForestDataType getDataType() {
        return ForestDataType.XML;
    }
}

