/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk;

import com.fangcloud.sdk.YfyProgressListener;
import com.fangcloud.sdk.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private final YfyProgressListener progressListener;
    private long total;
    private long totalWritten;
    private long lastWritten;
    private long speed;
    private long timestamp;

    public ProgressOutputStream(OutputStream outputStream, YfyProgressListener progressListener, long total) {
        this.outputStream = outputStream;
        this.progressListener = progressListener;
        this.total = total;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        ++this.totalWritten;
        this.calculateProgress();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
        this.totalWritten += (long)b.length;
        this.calculateProgress();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.totalWritten = len < b.length ? (this.totalWritten += (long)len) : (this.totalWritten += (long)b.length);
        this.calculateProgress();
    }

    private void calculateProgress() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp > 1000L) {
            this.speed = (this.totalWritten - this.lastWritten) * 1000L / (now - this.timestamp);
            this.lastWritten = this.totalWritten;
            this.timestamp = now;
            this.progressListener.onProgressChanged(this.totalWritten, this.total, StringUtil.formatBytes(this.speed) + "/s");
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

