/*
 * Decompiled with CFR 0.152.
 */
package com.fangcloud.sdk.api.department;

import com.fangcloud.sdk.YfyBaseClient;
import com.fangcloud.sdk.api.department.DepartmentChildrenResult;
import com.fangcloud.sdk.api.department.YfyDepartment;
import com.fangcloud.sdk.exception.YfyException;
import java.util.HashMap;
import java.util.Map;

public class YfyDepartmentRequest {
    private static final String DEPARTMENT_PATH = "api/v2/department/";
    private static final String DEPARTMENT_INFO_PATH = "api/v2/department/%s/info";
    private static final String DEPARTMENT_CHILDREN_PATH = "api/v2/department/%s/children";
    private final YfyBaseClient.YfyInternalClient client;

    public YfyDepartmentRequest(YfyBaseClient.YfyInternalClient client) {
        this.client = client;
    }

    public YfyDepartment getDepartment(long departmentId) throws YfyException {
        String[] params = new String[]{String.valueOf(departmentId)};
        return this.getDepartment(params);
    }

    private YfyDepartment getDepartment(String[] params) throws YfyException {
        return this.client.doGet(DEPARTMENT_INFO_PATH, params, null, YfyDepartment.class);
    }

    public DepartmentChildrenResult getDepartmentChildren(long departmentId, final boolean permissionFilter) throws YfyException {
        String[] params = new String[]{String.valueOf(departmentId)};
        HashMap<String, String> mapParams = new HashMap<String, String>(){
            {
                this.put("permission_filter", String.valueOf(permissionFilter));
            }
        };
        return this.getDepartmentChildren(params, (Map<String, String>)mapParams);
    }

    private DepartmentChildrenResult getDepartmentChildren(String[] params, Map<String, String> mapParams) throws YfyException {
        return this.client.doGet(DEPARTMENT_CHILDREN_PATH, params, mapParams, DepartmentChildrenResult.class);
    }
}

