/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.RedisTemplateWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.util.Pool;

@Configuration
public class WxMpStorageAutoConfiguration {
    private final ApplicationContext applicationContext;
    private final WxMpProperties wxMpProperties;
    @Value(value="${wx.mp.config-storage.redis.host:")
    private String redisHost;
    @Value(value="${wx.mp.configStorage.redis.host:")
    private String redisHost2;

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorage.class})
    public WxMpConfigStorage wxMpConfigStorage() {
        WxMpProperties.StorageType type = this.wxMpProperties.getConfigStorage().getType();
        WxMpConfigStorage config = type == WxMpProperties.StorageType.redis || type == WxMpProperties.StorageType.jedis ? this.wxMpInJedisConfigStorage() : (type == WxMpProperties.StorageType.redistemplate ? this.wxMpInRedisTemplateConfigStorage() : this.wxMpInMemoryConfigStorage());
        return config;
    }

    private WxMpConfigStorage wxMpInMemoryConfigStorage() {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        this.setWxMpInfo(config);
        return config;
    }

    private WxMpConfigStorage wxMpInJedisConfigStorage() {
        JedisPool jedisPool = StringUtils.isNotEmpty((CharSequence)this.redisHost) || StringUtils.isNotEmpty((CharSequence)this.redisHost2) ? this.getJedisPool() : (JedisPool)this.applicationContext.getBean(JedisPool.class);
        JedisWxRedisOps redisOps = new JedisWxRedisOps((Pool)jedisPool);
        WxMpRedisConfigImpl wxMpRedisConfig = new WxMpRedisConfigImpl((WxRedisOps)redisOps, this.wxMpProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxMpDefaultConfigImpl)wxMpRedisConfig);
        return wxMpRedisConfig;
    }

    private WxMpConfigStorage wxMpInRedisTemplateConfigStorage() {
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        RedisTemplateWxRedisOps redisOps = new RedisTemplateWxRedisOps(redisTemplate);
        WxMpRedisConfigImpl wxMpRedisConfig = new WxMpRedisConfigImpl((WxRedisOps)redisOps, this.wxMpProperties.getConfigStorage().getKeyPrefix());
        this.setWxMpInfo((WxMpDefaultConfigImpl)wxMpRedisConfig);
        return wxMpRedisConfig;
    }

    private void setWxMpInfo(WxMpDefaultConfigImpl config) {
        WxMpProperties properties = this.wxMpProperties;
        WxMpProperties.ConfigStorage configStorageProperties = properties.getConfigStorage();
        config.setAppId(properties.getAppId());
        config.setSecret(properties.getSecret());
        config.setToken(properties.getToken());
        config.setAesKey(properties.getAesKey());
        config.setHttpProxyHost(configStorageProperties.getHttpProxyHost());
        config.setHttpProxyUsername(configStorageProperties.getHttpProxyUsername());
        config.setHttpProxyPassword(configStorageProperties.getHttpProxyPassword());
        if (configStorageProperties.getHttpProxyPort() != null) {
            config.setHttpProxyPort(configStorageProperties.getHttpProxyPort().intValue());
        }
    }

    private JedisPool getJedisPool() {
        WxMpProperties.ConfigStorage storage = this.wxMpProperties.getConfigStorage();
        WxMpProperties.RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        return new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
    }

    public WxMpStorageAutoConfiguration(ApplicationContext applicationContext, WxMpProperties wxMpProperties) {
        this.applicationContext = applicationContext;
        this.wxMpProperties = wxMpProperties;
    }
}

