/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.web;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jetbrick.web.servlet.map.RequestAttributeMap;
import jetbrick.web.servlet.map.RequestParameterMap;
import jetbrick.web.servlet.map.RequestParameterValuesMap;
import jetbrick.web.servlet.map.SessionAttributeMap;

public final class JetWebContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION = "application";
    public static final String SESSION = "session";
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String APPLICATION_SCOPE = "applicationScope";
    public static final String SESSION_SCOPE = "sessionScope";
    public static final String REQUEST_SCOPE = "requestScope";
    public static final String PARAM = "param";
    public static final String PARAM_VALUES = "paramValues";
    public static final String CONTEXT_PATH = "CONTEXT_PATH";
    public static final String WEBROOT_PATH = "WEBROOT_PATH";
    public static final String BASE_PATH = "BASE_PATH";
    public static final String WEBROOT = "WEBROOT";
    protected static boolean SESSION_ENABLED = !"false".equals(System.getProperty("JetWebContext.session.enabled"));
    private final HttpServletRequest request;
    private final Map<String, Object> context;

    public static void disableSession() {
        SESSION_ENABLED = false;
    }

    public JetWebContext(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, null);
    }

    public JetWebContext(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) {
        this.request = request;
        this.context = context;
        this.put(REQUEST, request);
        this.put(REQUEST_SCOPE, TYPE.REQUEST_SCOPE);
        this.put(RESPONSE, response);
        if (SESSION_ENABLED) {
            this.put(SESSION, TYPE.SESSION);
            this.put(SESSION_SCOPE, TYPE.SESSION_SCOPE);
        }
        this.put(PARAM, TYPE.PARAM);
        this.put(PARAM_VALUES, TYPE.PARAM_VALUES);
        this.put(CONTEXT_PATH, TYPE.CONTEXT_PATH);
        this.put(WEBROOT_PATH, TYPE.WEBROOT_PATH);
        this.put(BASE_PATH, TYPE.BASE_PATH);
        this.put(WEBROOT, TYPE.WEBROOT_PATH);
    }

    @Override
    public Object get(Object key) {
        HttpSession session;
        Object value;
        String name = (String)key;
        if (name == null) {
            return null;
        }
        if (this.context != null && (value = this.context.get(name)) != null) {
            return value;
        }
        value = super.get(name);
        if (value != null) {
            if (value instanceof TYPE) {
                value = this.createImplicitWebObject((TYPE)((Object)value));
                this.put(name, value);
            }
            return value;
        }
        value = this.request.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (SESSION_ENABLED && (session = this.request.getSession(false)) != null && (value = session.getAttribute(name)) != null) {
            return value;
        }
        return this.request.getServletContext().getAttribute(name);
    }

    private Object createImplicitWebObject(TYPE type) {
        switch (type) {
            case REQUEST_SCOPE: {
                return new RequestAttributeMap(this.request);
            }
            case SESSION: {
                return this.request.getSession();
            }
            case SESSION_SCOPE: {
                return new SessionAttributeMap(this.request);
            }
            case PARAM: {
                return new RequestParameterMap(this.request);
            }
            case PARAM_VALUES: {
                return new RequestParameterValuesMap(this.request);
            }
            case CONTEXT_PATH: {
                return this.request.getContextPath();
            }
            case WEBROOT_PATH: {
                return this.getWebrootPath();
            }
            case BASE_PATH: {
                return this.getWebrootPath().concat("/");
            }
        }
        return null;
    }

    private String getWebrootPath() {
        StringBuilder sb = new StringBuilder();
        String schema = this.request.getScheme();
        int port = this.request.getServerPort();
        sb.append(schema);
        sb.append("://");
        sb.append(this.request.getServerName());
        if (!(port == 80 && "http".equals(schema) || port == 443 && "https".equals(schema))) {
            sb.append(':').append(this.request.getServerPort());
        }
        sb.append(this.request.getContextPath());
        return sb.toString();
    }

    private static enum TYPE {
        REQUEST_SCOPE,
        SESSION,
        SESSION_SCOPE,
        PARAM,
        PARAM_VALUES,
        CONTEXT_PATH,
        WEBROOT_PATH,
        BASE_PATH;

    }
}

