/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.web;

import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jetbrick.config.ConfigLoader;
import jetbrick.template.JetEngine;
import jetbrick.template.JetGlobalContext;
import jetbrick.template.loader.ServletResourceLoader;
import jetbrick.template.web.JetWebContext;
import jetbrick.template.web.buildin.JetWebFunctions;
import jetbrick.template.web.buildin.JetWebTags;
import jetbrick.web.servlet.map.ServletContextAttributeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JetWebEngine {
    private static final Logger log = LoggerFactory.getLogger(JetWebEngine.class);
    private static final String JET_ENGINE_KEY_NAME = JetEngine.class.getName();
    private static final String CONFIG_LOCATION_PARAMETER = "jetbrick-template-config-location";
    private static ServletContext servletContext;
    private static JetEngine engine;

    public static JetEngine create(ServletContext sc) {
        return JetWebEngine.create(sc, null, null);
    }

    public static JetEngine create(ServletContext sc, Properties config, String configLocation) {
        if (engine != null) {
            if (sc.getAttribute(JET_ENGINE_KEY_NAME) == engine) {
                return engine;
            }
            log.warn("webapp reloading: recreating the JetEngine ...");
        }
        servletContext = sc;
        engine = JetWebEngine.doCreateWebEngine(sc, config, configLocation);
        servletContext.setAttribute(JET_ENGINE_KEY_NAME, (Object)engine);
        return engine;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static JetEngine getEngine() {
        return engine;
    }

    private static JetEngine doCreateWebEngine(ServletContext sc, Properties config, String configLocation) {
        ConfigLoader loader = new ConfigLoader();
        loader.load("jetx.io.skiperrors", "true");
        loader.load("jetx.template.loaders", ServletResourceLoader.class.getName());
        if (config != null) {
            loader.load(config);
        }
        if (configLocation == null && ((configLocation = sc.getInitParameter(CONFIG_LOCATION_PARAMETER)) == null || configLocation.length() == 0)) {
            configLocation = "classpath:/jetbrick-template.properties";
        }
        try {
            log.info("Loading config file: {}", (Object)configLocation);
            loader.load(configLocation, sc);
        }
        catch (IllegalStateException e) {
            if (!"classpath:/jetbrick-template.properties".equals(configLocation)) {
                throw e;
            }
            log.warn("no default config file found: {}", (Object)"classpath:/jetbrick-template.properties");
        }
        JetEngine engine = JetEngine.create((Properties)loader.asProperties());
        JetGlobalContext ctx = engine.getGlobalContext();
        ctx.define(ServletContext.class, "application");
        ctx.define(HttpServletRequest.class, "request");
        ctx.define(HttpServletResponse.class, "response");
        ctx.define(Map.class, "applicationScope");
        ctx.define(Map.class, "requestScope");
        ctx.define(Map.class, "param");
        ctx.define(Map.class, "paramValues");
        if (JetWebContext.SESSION_ENABLED) {
            ctx.define(HttpSession.class, "session");
            ctx.define(Map.class, "sessionScope");
        }
        ctx.define(String.class, "CONTEXT_PATH");
        ctx.define(String.class, "WEBROOT_PATH");
        ctx.define(String.class, "WEBROOT");
        ctx.define(String.class, "BASE_PATH");
        ctx.set("application", (Object)sc);
        ctx.set("applicationScope", (Object)new ServletContextAttributeMap(sc));
        engine.getGlobalResolver().registerFunctions(JetWebFunctions.class);
        engine.getGlobalResolver().registerTags(JetWebTags.class);
        return engine;
    }
}

