/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.template.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.template.JetEngine;
import jetbrick.template.JetTemplate;
import jetbrick.template.web.JetWebContext;
import jetbrick.template.web.JetWebEngine;
import jetbrick.web.servlet.RequestUtils;

public final class JetTemplateServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private JetEngine engine;
    private String charsetEncoding;

    public void init() throws ServletException {
        this.engine = JetWebEngine.create(this.getServletContext());
        this.charsetEncoding = this.engine.getConfig().getOutputEncoding().name();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding(this.charsetEncoding);
        if (response.getContentType() == null) {
            response.setContentType("text/html; charset=" + this.charsetEncoding);
        }
        String path = RequestUtils.getPathInfo((HttpServletRequest)request);
        try {
            JetTemplate template = this.engine.getTemplate(path);
            JetWebContext context = new JetWebContext(request, response);
            template.render((Map)context, (OutputStream)response.getOutputStream());
        }
        catch (ResourceNotFoundException e) {
            response.sendError(404, "Template not found: " + path);
        }
    }
}

