/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.workflow.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.FlowEngine;
import com.jumipm.workflow.HttpDisposeUtil;
import com.jumipm.workflow.ProcessEngine;
import com.jumipm.workflow.impl.FlowElement;
import com.jumipm.workflow.impl.TaskInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="flowEngine")
public class FlowEngineImpl
implements FlowEngine {
    private static Log log = LogFactory.getLog(ProcessEngine.class);
    private volatile HttpDisposeUtil disposeUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpDisposeUtil getDisposeUtil() {
        if (this.disposeUtil == null) {
            FlowEngineImpl flowEngineImpl = this;
            synchronized (flowEngineImpl) {
                if (this.disposeUtil == null) {
                    this.disposeUtil = new HttpDisposeUtil(this.getEngineServiceUrl());
                }
            }
        }
        return this.disposeUtil;
    }

    public String getEngineServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("flow.engineUrl").concat("/service");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }

    public String getExplorerServiceUrl() {
        InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("application.properties");
        Properties prop = new Properties();
        String engineServiceUrl = "";
        try {
            prop.load(inStream);
            engineServiceUrl = prop.getProperty("explorer.engineUrl");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return engineServiceUrl;
    }

    @Override
    public String getDeployments() throws Exception {
        String serviceBase = "/repository/process-definitions?latest=true&start=0&size=2147483647";
        return this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
    }

    @Override
    public String getDeployment(String deployId) throws Exception {
        String serviceBase = "/repository/deployments/" + deployId;
        return this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
    }

    @Override
    public String getProcessDefinitions() throws Exception {
        String serviceBase = "/repository/process-definitions?start=0&size=2147483647";
        return this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
    }

    @Override
    public String getProcessGraphUrl(String processKey) throws Exception {
        String serviceBase = "/repository/process-definitions?key=" + processKey + "&latest=true";
        String processDefinition = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)processDefinition);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("id");
        String processImageUrl = String.valueOf(this.getExplorerServiceUrl()) + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId;
        return processImageUrl;
    }

    @Override
    public String getProcessTrackGraphUrl(String businessKey) throws Exception {
        String serviceBase = "/history/historic-process-instances?businessKey=" + businessKey;
        String processInstances = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)processInstances);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("processDefinitionId");
        String processInstanceId = dataObjJson.getString("id");
        String processTrackGraphUrl = String.valueOf(this.getExplorerServiceUrl()) + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId + "&processInstanceId=" + processInstanceId;
        return processTrackGraphUrl;
    }

    @Override
    public String getProcessDefinetionId(String processKey) throws Exception {
        String serviceBase = "/repository/process-definitions?key=" + processKey + "&latest=true";
        String processDefinition = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)processDefinition);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("id");
        return processDefinitionId;
    }

    @Override
    public String getProcessDefinitionById(String processDefinitionId) throws Exception {
        String serviceBase = "/repository/process-definitions/" + processDefinitionId;
        String jsonString = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        return jsonString;
    }

    @Override
    public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId) throws Exception {
        String activitiProcessTrackUrl = "/runtime/process-instances/" + processInstanceId + "/diagram";
        this.getDisposeUtil().getResponseForURLConnection("GET", activitiProcessTrackUrl);
        return activitiProcessTrackUrl;
    }

    @Override
    public String getProcessDefinitionByKey(String processDefinitionKey) {
        throw new RuntimeException("\u8fd8\u672a\u5b9e\u73b0");
    }

    @Override
    public byte[] getProcessDefinitionImage(String processDefinitionId) throws Exception {
        String serviceBase = "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)processDefinition);
        String diagramResource = json.getString("diagramResource");
        String diagramResource2 = this.getDisposeUtil().getResponseForURLConnection("GET", diagramResource);
        String contentUrl = JSON.parseObject((String)diagramResource2).getString("contentUrl");
        this.getDisposeUtil().getResponseForURLConnection("GET", contentUrl);
        return null;
    }

    @Override
    public byte[] getProcessDefinitionImageByKey(String processKey) throws Exception {
        String processDefinitionId = this.getProcessDefinetionId(processKey);
        String serviceBase = "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)processDefinition);
        String diagramResource = json.getString("diagramResource");
        String diagramResource2 = this.getDisposeUtil().getResponseForURLConnection("GET", diagramResource);
        String contentUrl = JSON.parseObject((String)diagramResource2).getString("contentUrl");
        this.getDisposeUtil().getResponseForURLConnection("GET", contentUrl);
        return null;
    }

    @Override
    public String startProcessById(String processDefinitionId, String businessKey, JSONArray variables) throws Exception {
        log.debug((Object)("start process by id:" + processDefinitionId));
        String serviceBase = "/runtime/process-instances";
        JSONObject json = new JSONObject();
        json.put("processDefinitionId", (Object)processDefinitionId);
        json.put("businessKey", (Object)businessKey);
        json.put("variables", (Object)variables);
        String resp = this.getDisposeUtil().getResponseForURLConnectionParam("GET", serviceBase, json.toString());
        return JSON.parseObject((String)resp).getString("id");
    }

    @Override
    public String startProcessByKey(String processDefinitionKey, String businessKey, JSONArray variables) throws Exception {
        log.debug((Object)("start process by key:" + processDefinitionKey));
        String serviceBase = "/runtime/process-instances";
        HashMap<String, String> variablesR = new HashMap<String, String>();
        variablesR.put("processDefinitionKey", processDefinitionKey);
        variablesR.put("businessKey", businessKey);
        JSONObject startParams = new JSONObject();
        startParams.putAll(variablesR);
        String resp = this.getDisposeUtil().getResponseForJsonURLConnection(serviceBase, "POST", startParams.toString());
        log.debug((Object)("processInstance:" + resp));
        return JSON.parseObject((String)resp).getString("id");
    }

    public String appointStartProcessByKey(String processDefinitionKey, String businessKey, JSONArray variables) throws Exception {
        log.debug((Object)("start process by key:" + processDefinitionKey));
        String serviceBase = "/runtime/process-instances";
        JSONObject json = new JSONObject();
        json.put("processDefinitionKey", (Object)processDefinitionKey);
        json.put("businessKey", (Object)businessKey);
        json.put("variables", (Object)variables);
        String resp = this.getDisposeUtil().getResponseForJsonURLConnection(serviceBase, "POST", json.toString());
        log.debug((Object)("processInstance:" + resp));
        return JSON.parseObject((String)resp).getString("id");
    }

    @Override
    public void appointStartProcessByKey(String processDefinitionKey, String businessKey, String assigneeOrRole, String owner, String description, JSONArray variables) throws Exception {
        this.startProcessByKey(processDefinitionKey, businessKey, null);
        this.appointCompleteTask(businessKey, assigneeOrRole, owner, description, variables);
    }

    @Override
    public List<TaskInfo> getMyTask(String userId) throws Exception {
        String serviceBase = "/runtime/tasks?assignee=" + userId;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List<String> getTodoBusinessKeyByAssignee(String userId) throws Exception {
        String serviceBase = "/runtime/tasks?assignee=" + userId;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            JSONObject jsonObj = this.getJsonObjProcessInstanceById(data.getJSONObject(i).getString("processInstanceId"));
            list.add(jsonObj.getString("businessKey"));
            ++i;
        }
        return list;
    }

    @Override
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId) throws Exception {
        String serviceBase = "/runtime/process-instances/" + processInstanceId;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject data = JSON.parseObject((String)resp);
        return data;
    }

    @Override
    public List<TaskInfo> getMyTask(String userId, String processDefinitionKey) throws Exception {
        log.debug((Object)("get my task userId:" + userId + " processDefinitionKey:" + processDefinitionKey));
        String serviceBase = "/runtime/tasks?assignee=" + userId + "&processDefinitionKey=" + processDefinitionKey;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List<TaskInfo> getMyHistoryTask(String bussinessKey) throws Exception {
        String serviceBase = "/history/historic-task-instances?processBusinessKey=" + bussinessKey;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("getMyHistoryTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List getCandidaTask(String userId) throws Exception {
        String serviceBase = "/query/tasks";
        JSONObject json = new JSONObject();
        json.put("candidateUser", (Object)userId);
        String resp = this.getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
        log.debug((Object)("candida:" + resp));
        JSONObject jsonTask = JSON.parseObject((String)resp);
        return null;
    }

    @Override
    public List getGroupTask(String userId) throws Exception {
        String serviceBase = "/identity/groups";
        JSONObject json = new JSONObject();
        json.put("member", (Object)userId);
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("groups:" + resp));
        JSONObject jsonGroup = JSON.parseObject((String)resp);
        JSONArray array = jsonGroup.getJSONArray("data");
        String groups = "";
        int i = 0;
        while (i < array.size()) {
            if (i > 0) {
                groups = String.valueOf(groups) + ",";
            }
            groups = String.valueOf(groups) + array.getJSONObject(i).getString("id");
            ++i;
        }
        log.debug((Object)("groups:" + groups));
        this.getGroupTaskList("management,marketing,sales");
        return null;
    }

    public List getGroupTaskList(String groups) throws Exception {
        String serviceBase = "/runtime/tasks?candidateGroups=" + groups;
        JSONObject json = new JSONObject();
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("groupTask:" + resp));
        return null;
    }

    @Override
    public void claimTask(String taskId, String userId) throws Exception {
        String serviceBase = "/runtime/tasks/" + taskId;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"claim");
        json.put("assignee", (Object)userId);
        this.getDisposeUtil().getResponseForJsonURLConnection(serviceBase, "POST", json.toString());
    }

    @Override
    public void completeTask(String taskId, JSONArray variables) throws Exception {
        log.debug((Object)("complete task:" + taskId));
        String serviceBase = "/runtime/tasks/" + taskId;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"complete");
        json.put("isAgree", (Object)1);
        String resp = this.getDisposeUtil().getResponseForJsonURLConnection(serviceBase, "POST", json.toString());
        log.debug((Object)("resp:" + resp));
    }

    @Override
    public void updateTask(String taskId, String description, String owner) throws Exception {
        log.debug((Object)("complete task:" + taskId));
        String serviceBase = "/runtime/tasks/" + taskId;
        HashMap<String, String> variablesR = new HashMap<String, String>();
        variablesR.put("description", description);
        variablesR.put("owner", owner);
        JSONObject updateParams = new JSONObject();
        updateParams.putAll(variablesR);
        String resp = this.getDisposeUtil().getResponseForURLConnectionParam("PUT", serviceBase, updateParams.toString());
        log.debug((Object)("resp:" + resp));
    }

    @Override
    public int appointCompleteTask(String businessKey, String assigneeOrRole, String owner, String description, JSONArray variables) throws Exception {
        int completeResult = 0;
        TaskInfo task = this.getTaskByBusinessKey(businessKey);
        this.completeTask(task.getTaskId(), variables);
        TaskInfo taskR = this.getTaskByBusinessKey(businessKey);
        if (taskR != null) {
            this.updateTask(taskR.getTaskId(), description, owner);
            TaskInfo taskClaim = this.getTaskByBusinessKey(businessKey);
            this.claimTask(taskClaim.getTaskId(), assigneeOrRole);
        } else {
            this.updateTask(task.getTaskId(), description, owner);
            completeResult = 1;
        }
        return completeResult;
    }

    @Override
    public TaskInfo getTaskByBusinessKey(String businessKey) throws Exception {
        String serviceBase = "/runtime/tasks?processInstanceBusinessKey=" + businessKey;
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        if (data == null || data.size() == 0) {
            return null;
        }
        return new TaskInfo(data.getJSONObject(0));
    }

    @Override
    public List getHistoryTask(String userId) {
        return null;
    }

    @Override
    public void addUser(String id, String firstName, String lastName, String email, String password) throws Exception {
        String serviceBase = "/identity/users";
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("firstName", (Object)firstName);
        json.put("lastName", (Object)lastName);
        json.put("email", (Object)email);
        json.put("password", (Object)password);
        String resp = this.getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
        log.debug((Object)("add user resp:" + resp));
    }

    @Override
    public void addUserToGroup(String userId, String groupId) throws Exception {
        String serviceBase = "/identity/groups/" + groupId + "/members";
        JSONObject json = new JSONObject();
        json.put("userId", (Object)userId);
        String resp = this.getDisposeUtil().getResponseForURLConnectionParam("POST", serviceBase, json.toString());
        log.debug((Object)("add user to Group resp:" + resp));
    }

    @Override
    public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId) throws Exception {
        String serviceBase = "/repository/process-definitions/" + processDefinitionId + "/model";
        String resp = this.getDisposeUtil().getResponseForURLConnection("GET", serviceBase);
        JSONObject json = JSON.parseObject((String)resp);
        String processes = json.getString("processes");
        JSONArray processesJSONArray = JSONArray.parseArray((String)processes);
        JSONObject jsonR = JSON.parseObject((String)processesJSONArray.get(0).toString());
        String flowElements = jsonR.getString("flowElements");
        JSONArray flowElementsJSONArray = JSONArray.parseArray((String)flowElements);
        ArrayList<FlowElement> flowElementsR = new ArrayList<FlowElement>();
        int i = 0;
        while (i < flowElementsJSONArray.size()) {
            JSONObject flowElementsJson = JSON.parseObject((String)flowElementsJSONArray.get(i).toString());
            if (flowElementsJson.getString("name") != null) {
                flowElementsR.add(new FlowElement(flowElementsJson));
            }
            ++i;
        }
        return flowElementsR;
    }
}

