/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.workflow.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.workflow.ProcessEngine;
import com.jumipm.workflow.impl.FlowElement;
import com.jumipm.workflow.impl.TaskInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service(value="processEngine")
public class ProcessEngineImpl
implements ProcessEngine {
    private static Log log = LogFactory.getLog(ProcessEngine.class);
    public static RestTemplate restTemplate = new RestTemplate();
    HttpHeaders headers;
    HttpEntity<String> _noParamEntity;
    String baseURI = null;
    String baseExplorerURI = null;

    public ProcessEngineImpl() {
        this.initHeader();
        this.initURI();
    }

    private void initHeader() {
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        String encodedToken = "Basic " + Base64.encodeBase64String((byte[])"kermit:kermit".getBytes());
        this.headers.set("Authorization", encodedToken);
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        this.headers.setContentType(type);
        this.headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        this._noParamEntity = new HttpEntity((Object)"", (MultiValueMap)this.headers);
    }

    public HttpEntity<String> getHttpEntity(JSONObject json) {
        if (json == null) {
            return this._noParamEntity;
        }
        log.debug((Object)("json:" + json.toString()));
        return new HttpEntity((Object)json.toString(), (MultiValueMap)this.headers);
    }

    private void initURI() {
        this.baseURI = "http://180.168.15.99:8050/activiti-rest/service";
        this.baseExplorerURI = "http://180.168.15.99:8050/activiti-explorer";
    }

    @Override
    public String getDeployments() {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions?latest=true&start=0&size=" + Integer.MAX_VALUE;
        return this.getRestString(serviceBase, HttpMethod.GET, null);
    }

    @Override
    public String getDeployment(String deployId) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/deployments/" + deployId;
        return this.getRestString(serviceBase, HttpMethod.GET, null);
    }

    @Override
    public String getProcessDefinitions() {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions?start=0&size=" + Integer.MAX_VALUE;
        return this.getRestString(serviceBase, HttpMethod.GET, null);
    }

    @Override
    public String getProcessGraphUrl(String processKey) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions?key=" + processKey + "&latest=true";
        String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)processDefinition);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("id");
        String processImageUrl = String.valueOf(this.baseExplorerURI) + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId;
        return processImageUrl;
    }

    @Override
    public String getProcessTrackGraphUrl(String businessKey) {
        String serviceBase = String.valueOf(this.baseURI) + "/history/historic-process-instances?businessKey=" + businessKey;
        String processInstances = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)processInstances);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("processDefinitionId");
        String processInstanceId = dataObjJson.getString("id");
        String processTrackGraphUrl = String.valueOf(this.baseExplorerURI) + "/diagram-viewer/index.html?processDefinitionId=" + processDefinitionId + "&processInstanceId=" + processInstanceId;
        return processTrackGraphUrl;
    }

    @Override
    public String getProcessDefinetionId(String processKey) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions?key=" + processKey + "&latest=true";
        String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)processDefinition);
        JSONArray data = json.getJSONArray("data");
        JSONObject dataObjJson = data.getJSONObject(0);
        String processDefinitionId = dataObjJson.getString("id");
        return processDefinitionId;
    }

    private byte[] getRestByte(String restURI, HttpMethod method, JSONObject json) {
        return (byte[])restTemplate.exchange(restURI, method, this.getHttpEntity(json), byte[].class, new Object[0]).getBody();
    }

    private String getRestString(String restURI, HttpMethod method, JSONObject json) {
        byte[] bytes;
        block4: {
            bytes = this.getRestByte(restURI, method, json);
            if (bytes != null) break block4;
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (RestClientException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getProcessDefinitionById(String processDefinitionId) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions/" + processDefinitionId;
        return this.getRestString(serviceBase, HttpMethod.GET, null);
    }

    @Override
    public String getActivitiProcessTrackByProcessInstanceId(String processInstanceId) {
        String activitiProcessTrackUrl = String.valueOf(this.baseURI) + "/runtime/process-instances/" + processInstanceId + "/diagram";
        this.getRestString(activitiProcessTrackUrl, HttpMethod.GET, null);
        return activitiProcessTrackUrl;
    }

    @Override
    public String getProcessDefinitionByKey(String processDefinitionKey) {
        throw new RuntimeException("\u8fd8\u672a\u5b9e\u73b0");
    }

    @Override
    public byte[] getProcessDefinitionImage(String processDefinitionId) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)processDefinition);
        String diagramResource = json.getString("diagramResource");
        String diagramResource2 = this.getRestString(diagramResource, HttpMethod.GET, null);
        String contentUrl = JSON.parseObject((String)diagramResource2).getString("contentUrl");
        byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
        return image;
    }

    @Override
    public byte[] getProcessDefinitionImageByKey(String processKey) {
        String processDefinitionId = this.getProcessDefinetionId(processKey);
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions/" + processDefinitionId;
        String processDefinition = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)processDefinition);
        String diagramResource = json.getString("diagramResource");
        String diagramResource2 = this.getRestString(diagramResource, HttpMethod.GET, null);
        String contentUrl = JSON.parseObject((String)diagramResource2).getString("contentUrl");
        byte[] image = this.getRestByte(contentUrl, HttpMethod.GET, null);
        return image;
    }

    @Override
    public String startProcessById(String processDefinitionId, String businessKey, JSONArray variables) {
        log.debug((Object)("start process by id:" + processDefinitionId));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/process-instances";
        JSONObject json = new JSONObject();
        json.put("processDefinitionId", (Object)processDefinitionId);
        json.put("businessKey", (Object)businessKey);
        json.put("variables", (Object)variables);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        return JSON.parseObject((String)resp).getString("id");
    }

    @Override
    public String startProcessByKey(String processDefinitionKey, String businessKey, JSONArray variables) {
        log.debug((Object)("start process by key:" + processDefinitionKey));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/process-instances";
        JSONObject json = new JSONObject();
        json.put("processDefinitionKey", (Object)processDefinitionKey);
        json.put("businessKey", (Object)businessKey);
        json.put("variables", (Object)variables);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("processInstance:" + resp));
        return JSON.parseObject((String)resp).getString("id");
    }

    public String appointStartProcessByKey(String processDefinitionKey, String businessKey, JSONArray variables) {
        log.debug((Object)("start process by key:" + processDefinitionKey));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/process-instances";
        JSONObject json = new JSONObject();
        json.put("processDefinitionKey", (Object)processDefinitionKey);
        json.put("businessKey", (Object)businessKey);
        json.put("variables", (Object)variables);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("processInstance:" + resp));
        return JSON.parseObject((String)resp).getString("id");
    }

    @Override
    public void appointStartProcessByKey(String processDefinitionKey, String businessKey, String assigneeOrRole, String owner, String description, JSONArray variables) {
        this.startProcessByKey(processDefinitionKey, businessKey, null);
        this.appointCompleteTask(businessKey, assigneeOrRole, owner, description, variables);
    }

    @Override
    public List<TaskInfo> getMyTask(String userId) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks?assignee=" + userId;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List<String> getTodoBusinessKeyByAssignee(String userId) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks?assignee=" + userId;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            JSONObject jsonObj = this.getJsonObjProcessInstanceById(data.getJSONObject(i).getString("processInstanceId"));
            list.add(jsonObj.getString("businessKey"));
            ++i;
        }
        return list;
    }

    @Override
    public JSONObject getJsonObjProcessInstanceById(String processInstanceId) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/process-instances/" + processInstanceId;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject data = JSON.parseObject((String)resp);
        return data;
    }

    @Override
    public List<TaskInfo> getMyTask(String userId, String processDefinitionKey) {
        log.debug((Object)("get my task userId:" + userId + " processDefinitionKey:" + processDefinitionKey));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks?assignee=" + userId + "&processDefinitionKey=" + processDefinitionKey;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List<TaskInfo> getMyHistoryTask(String bussinessKey) {
        String serviceBase = String.valueOf(this.baseURI) + "/history/historic-task-instances?processBusinessKey=" + bussinessKey;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("getMyHistoryTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        ArrayList<TaskInfo> list = new ArrayList<TaskInfo>();
        int i = 0;
        while (i < data.size()) {
            log.debug((Object)("data[" + i + "]:" + data.getJSONObject(i)));
            list.add(new TaskInfo(data.getJSONObject(i)));
            ++i;
        }
        return list;
    }

    @Override
    public List getCandidaTask(String userId) {
        String serviceBase = String.valueOf(this.baseURI) + "/query/tasks";
        JSONObject json = new JSONObject();
        json.put("candidateUser", (Object)userId);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("candida:" + resp));
        JSONObject jsonTask = JSON.parseObject((String)resp);
        return null;
    }

    @Override
    public List getGroupTask(String userId) {
        String serviceBase = String.valueOf(this.baseURI) + "/identity/groups";
        JSONObject json = new JSONObject();
        json.put("member", (Object)userId);
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("groups:" + resp));
        JSONObject jsonGroup = JSON.parseObject((String)resp);
        JSONArray array = jsonGroup.getJSONArray("data");
        String groups = "";
        int i = 0;
        while (i < array.size()) {
            if (i > 0) {
                groups = String.valueOf(groups) + ",";
            }
            groups = String.valueOf(groups) + array.getJSONObject(i).getString("id");
            ++i;
        }
        log.debug((Object)("groups:" + groups));
        this.getGroupTaskList("management,marketing,sales");
        return null;
    }

    public List getGroupTaskList(String groups) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks?candidateGroups=" + groups;
        JSONObject json = new JSONObject();
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("groupTask:" + resp));
        return null;
    }

    @Override
    public void claimTask(String taskId, String userId) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks/" + taskId;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"claim");
        json.put("assignee", (Object)userId);
        this.getRestString(serviceBase, HttpMethod.POST, json);
    }

    @Override
    public void completeTask(String taskId, JSONArray variables) {
        log.debug((Object)("complete task:" + taskId));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks/" + taskId;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"complete");
        JSONArray variablesIn = new JSONArray();
        if (variables != null) {
            for (JSONObject ob : variables) {
                for (String key : ob.keySet()) {
                    String value = ob.getString(key);
                    RestVariable restVariable = new RestVariable();
                    restVariable.setName(key);
                    restVariable.setValue(value);
                    variablesIn.add((Object)restVariable);
                    json.put("variables", (Object)variablesIn);
                }
            }
        }
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("resp:" + resp));
    }

    @Override
    public void updateTask(String taskId, String description, String owner) {
        log.debug((Object)("complete task:" + taskId));
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks/" + taskId;
        JSONObject json = new JSONObject();
        if (description != null && !"".equals(description)) {
            json.put("description", (Object)description);
        }
        if (owner != null && !"".equals(owner)) {
            json.put("owner", (Object)owner);
        }
        String resp = this.getRestString(serviceBase, HttpMethod.PUT, json);
        log.debug((Object)("resp:" + resp));
    }

    @Override
    public int appointCompleteTask(String businessKey, String assigneeOrRole, String owner, String description, JSONArray variables) {
        int completeResult = 0;
        TaskInfo task = this.getTaskByBusinessKey(businessKey);
        this.updateTask(task.getTaskId(), description, owner);
        this.completeTask(task.getTaskId(), variables);
        TaskInfo taskR = this.getTaskByBusinessKey(businessKey);
        if (taskR != null) {
            this.updateTask(taskR.getTaskId(), null, owner);
            TaskInfo taskClaim = this.getTaskByBusinessKey(businessKey);
            this.claimTask(taskClaim.getTaskId(), assigneeOrRole);
        } else {
            completeResult = 1;
        }
        return completeResult;
    }

    @Override
    public TaskInfo getTaskByBusinessKey(String businessKey) {
        String serviceBase = String.valueOf(this.baseURI) + "/runtime/tasks?processInstanceBusinessKey=" + businessKey;
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        log.debug((Object)("getMyTask:" + resp));
        JSONObject json = JSON.parseObject((String)resp);
        JSONArray data = json.getJSONArray("data");
        log.debug((Object)("data.length:" + data.size()));
        if (data == null || data.size() == 0) {
            return null;
        }
        return new TaskInfo(data.getJSONObject(0));
    }

    @Override
    public List getHistoryTask(String userId) {
        return null;
    }

    @Override
    public void addUser(String id, String firstName, String lastName, String email, String password) {
        String serviceBase = String.valueOf(this.baseURI) + "/identity/users";
        JSONObject json = new JSONObject();
        json.put("id", (Object)id);
        json.put("firstName", (Object)firstName);
        json.put("lastName", (Object)lastName);
        json.put("email", (Object)email);
        json.put("password", (Object)password);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("add user resp:" + resp));
    }

    @Override
    public void addUserToGroup(String userId, String groupId) {
        String serviceBase = String.valueOf(this.baseURI) + "/identity/groups/" + groupId + "/members";
        JSONObject json = new JSONObject();
        json.put("userId", (Object)userId);
        String resp = this.getRestString(serviceBase, HttpMethod.POST, json);
        log.debug((Object)("add user to Group resp:" + resp));
    }

    @Override
    public List<FlowElement> getFlowElementsByDefinitionId(String processDefinitionId) {
        String serviceBase = String.valueOf(this.baseURI) + "/repository/process-definitions/" + processDefinitionId + "/model";
        String resp = this.getRestString(serviceBase, HttpMethod.GET, null);
        JSONObject json = JSON.parseObject((String)resp);
        String processes = json.getString("processes");
        JSONArray processesJSONArray = JSONArray.parseArray((String)processes);
        JSONObject jsonR = JSON.parseObject((String)processesJSONArray.get(0).toString());
        String flowElements = jsonR.getString("flowElements");
        JSONArray flowElementsJSONArray = JSONArray.parseArray((String)flowElements);
        ArrayList<FlowElement> flowElementsR = new ArrayList<FlowElement>();
        int i = 0;
        while (i < flowElementsJSONArray.size()) {
            JSONObject flowElementsJson = JSON.parseObject((String)flowElementsJSONArray.get(i).toString());
            if (flowElementsJson.getString("name") != null) {
                flowElementsR.add(new FlowElement(flowElementsJson));
            }
            ++i;
        }
        return flowElementsR;
    }
}

