/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.engine.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class RestVariable {
    private String name;
    private String type;
    private RestVariableScope variableScope;
    private Object value;
    private String valueUrl;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public RestVariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(RestVariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getScope() {
        String scope = null;
        if (this.variableScope != null) {
            scope = this.variableScope.name().toLowerCase();
        }
        return scope;
    }

    public void setScope(String scope) {
        this.setVariableScope(RestVariable.getScopeFromString(scope));
    }

    public void setValueUrl(String valueUrl) {
        this.valueUrl = valueUrl;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public String getValueUrl() {
        return this.valueUrl;
    }

    public static RestVariableScope getScopeFromString(String scope) {
        if (scope != null) {
            RestVariableScope[] restVariableScopeArray = RestVariableScope.values();
            int n = restVariableScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RestVariableScope s = restVariableScopeArray[n2];
                if (s.name().equalsIgnoreCase(scope)) {
                    return s;
                }
                ++n2;
            }
        }
        return null;
    }

    public static enum RestVariableScope {
        LOCAL,
        GLOBAL;

    }
}

