/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import brave.http.HttpClientAdapter;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.SpanTags;
import javax.annotation.Nullable;

final class ArmeriaHttpClientAdapter
extends HttpClientAdapter<RequestLog, RequestLog> {
    private static final ArmeriaHttpClientAdapter INSTANCE = new ArmeriaHttpClientAdapter();

    static ArmeriaHttpClientAdapter get() {
        return INSTANCE;
    }

    private ArmeriaHttpClientAdapter() {
    }

    public String method(RequestLog requestLog) {
        return requestLog.method().name();
    }

    public String path(RequestLog requestLog) {
        return requestLog.path();
    }

    @Nullable
    public String url(RequestLog requestLog) {
        return SpanTags.generateUrl(requestLog);
    }

    @Nullable
    public String requestHeader(RequestLog requestLog, String name) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return null;
        }
        return requestLog.requestHeaders().get((CharSequence)name);
    }

    @Nullable
    public Integer statusCode(RequestLog requestLog) {
        int result = this.statusCodeAsInt(requestLog);
        return result != 0 ? Integer.valueOf(result) : null;
    }

    public int statusCodeAsInt(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
            return 0;
        }
        return requestLog.status().code();
    }

    @Nullable
    public String authority(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return null;
        }
        return requestLog.authority();
    }

    @Nullable
    public String protocol(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.SCHEME)) {
            return null;
        }
        return requestLog.scheme().sessionProtocol().uriText();
    }

    @Nullable
    public String serializationFormat(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.SCHEME)) {
            return null;
        }
        SerializationFormat serFmt = requestLog.scheme().serializationFormat();
        return serFmt == SerializationFormat.NONE ? null : serFmt.uriText();
    }

    @Nullable
    public String rpcMethod(RequestLog requestLog) {
        if (!requestLog.isAvailable(RequestLogAvailability.REQUEST_CONTENT)) {
            return null;
        }
        Object requestContent = requestLog.requestContent();
        return requestContent instanceof RpcRequest ? ((RpcRequest)requestContent).method() : null;
    }
}

