/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpAdapter;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpClientParser;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.brave.ArmeriaHttpClientAdapter;
import com.linecorp.armeria.client.brave.ArmeriaHttpClientParser;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.brave.RequestContextCurrentTraceContext;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.brave.AsciiStringKeyFactory;
import com.linecorp.armeria.internal.brave.SpanContextUtil;
import com.linecorp.armeria.internal.brave.SpanTags;
import com.linecorp.armeria.internal.brave.TraceContextUtil;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraveClient
extends SimpleDecoratingHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(BraveClient.class);
    private final Tracer tracer;
    private final TraceContext.Injector<RequestHeadersBuilder> injector;
    private final HttpClientHandler<RequestLog, RequestLog> handler;
    private final CurrentTraceContext currentTraceContext;
    private final ArmeriaHttpClientAdapter adapter;
    private final HttpClientParser clientParser;

    public static Function<Client<HttpRequest, HttpResponse>, BraveClient> newDecorator(Tracing tracing) {
        return BraveClient.newDecorator(tracing, null);
    }

    public static Function<Client<HttpRequest, HttpResponse>, BraveClient> newDecorator(Tracing tracing, @Nullable String remoteServiceName) {
        HttpTracing httpTracing = HttpTracing.newBuilder((Tracing)tracing).clientParser((HttpClientParser)ArmeriaHttpClientParser.get()).build();
        if (remoteServiceName != null) {
            httpTracing = httpTracing.clientOf(remoteServiceName);
        }
        return BraveClient.newDecorator(httpTracing);
    }

    public static Function<Client<HttpRequest, HttpResponse>, BraveClient> newDecorator(HttpTracing httpTracing) {
        try {
            RequestContextCurrentTraceContext.ensureScopeUsesRequestContext(httpTracing.tracing());
        }
        catch (IllegalStateException e) {
            logger.warn("{} - it is appropriate to ignore this warning if this client is not being used inside an Armeria server (e.g., this is a normal spring-mvc tomcat server).", (Object)e.getMessage());
        }
        return delegate -> new BraveClient((Client<HttpRequest, HttpResponse>)delegate, httpTracing);
    }

    private BraveClient(Client<HttpRequest, HttpResponse> delegate, HttpTracing httpTracing) {
        super(delegate);
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.tracer = httpTracing.tracing().tracer();
        this.clientParser = httpTracing.clientParser();
        this.adapter = ArmeriaHttpClientAdapter.get();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)this.adapter);
        this.injector = httpTracing.tracing().propagationFactory().create((Propagation.KeyFactory)AsciiStringKeyFactory.INSTANCE).injector(RequestHeadersBuilder::set);
    }

    public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) throws Exception {
        RequestHeadersBuilder newHeaders = req.headers().toBuilder();
        Span span = this.handler.handleSend(this.injector, (Object)newHeaders, (Object)ctx.log());
        req = HttpRequest.of((HttpRequest)req, (RequestHeaders)newHeaders.build());
        ctx.updateRequest((Request)req);
        ctx.onChild(TraceContextUtil::copy);
        if (span.isNoop()) {
            try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
                HttpResponse httpResponse = (HttpResponse)this.delegate().execute(ctx, (Request)req);
                return httpResponse;
            }
        }
        ctx.log().addListener(log -> SpanContextUtil.startSpan(span, log), RequestLogAvailability.REQUEST_START);
        ctx.log().addListener(log -> {
            if (log.isAvailable(RequestLogAvailability.REQUEST_FIRST_BYTES_TRANSFERRED)) {
                SpanTags.logWireSend(span, log.requestFirstBytesTransferredTimeNanos(), log);
            }
            if (log.isAvailable(RequestLogAvailability.RESPONSE_FIRST_BYTES_TRANSFERRED)) {
                SpanTags.logWireReceive(span, log.responseFirstBytesTransferredTimeNanos(), log);
            }
            SpanTags.updateRemoteEndpoint(span, log);
            this.handleFinish(log, span);
        }, RequestLogAvailability.COMPLETE);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            HttpResponse httpResponse = (HttpResponse)this.delegate().execute(ctx, (Request)req);
            return httpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFinish(RequestLog requestLog, Span span) {
        if (span.isNoop()) {
            return;
        }
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());){
            this.clientParser.response((HttpAdapter)this.adapter, (Object)requestLog, requestLog.responseCause(), span.customizer());
        }
        finally {
            this.finishInNullScope(span, requestLog);
        }
    }

    private void finishInNullScope(Span span, RequestLog requestLog) {
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(null);){
            span.finish(SpanContextUtil.wallTimeMicros(requestLog, requestLog.responseEndTimeNanos()));
        }
    }
}

