/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.brave;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.brave.TraceContextUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.netty.util.Attribute;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestContextCurrentTraceContext
extends CurrentTraceContext {
    private static final CurrentTraceContext DEFAULT = new RequestContextCurrentTraceContext(new Builder());
    private static final Logger logger = LoggerFactory.getLogger(RequestContextCurrentTraceContext.class);
    private static final ThreadLocal<TraceContext> THREAD_LOCAL_CONTEXT = new ThreadLocal();
    private static final ThreadLocal<Boolean> THREAD_NOT_REQUEST_THREAD = new ThreadLocal();
    private static final CurrentTraceContext.Scope INITIAL_REQUEST_SCOPE = new CurrentTraceContext.Scope(){

        public void close() {
        }

        public String toString() {
            return "InitialRequestScope";
        }
    };

    public static void setCurrentThreadNotRequestThread(boolean value) {
        if (value) {
            THREAD_NOT_REQUEST_THREAD.set(true);
        } else {
            THREAD_NOT_REQUEST_THREAD.remove();
        }
    }

    public static CurrentTraceContext ofDefault() {
        return DEFAULT;
    }

    public static CurrentTraceContext.Builder builder() {
        return new Builder();
    }

    public static void ensureScopeUsesRequestContext(Tracing tracing) {
        boolean scopeUsesRequestContext;
        Objects.requireNonNull(tracing, "tracing");
        PingPongExtra extra = new PingPongExtra();
        TraceContext dummyContext = TraceContext.newBuilder().traceId(1L).spanId(1L).extra(Collections.singletonList(extra)).build();
        try (CurrentTraceContext.Scope scope = tracing.currentTraceContext().newScope(dummyContext);){
            scopeUsesRequestContext = extra.isPong();
        }
        if (!scopeUsesRequestContext) {
            throw new IllegalStateException("Tracing.currentTraceContext is not a " + RequestContextCurrentTraceContext.class.getSimpleName() + " scope. Please call Tracing.Builder.currentTraceContext(" + RequestContextCurrentTraceContext.class.getSimpleName() + ".ofDefault()).");
        }
    }

    private RequestContextCurrentTraceContext(Builder builder) {
        super((CurrentTraceContext.Builder)builder);
    }

    @Nullable
    public TraceContext get() {
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return THREAD_LOCAL_CONTEXT.get();
        }
        if (ctx.eventLoop().inEventLoop()) {
            return (TraceContext)TraceContextUtil.getTraceContextAttribute(ctx).get();
        }
        TraceContext threadLocalContext = THREAD_LOCAL_CONTEXT.get();
        if (threadLocalContext != null) {
            return threadLocalContext;
        }
        return (TraceContext)TraceContextUtil.getTraceContextAttribute(ctx).get();
    }

    public CurrentTraceContext.Scope newScope(@Nullable TraceContext currentSpan) {
        if (currentSpan != null && PingPongExtra.maybeSetPong(currentSpan)) {
            return CurrentTraceContext.Scope.NOOP;
        }
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx != null && ctx.eventLoop().inEventLoop()) {
            return this.createScopeForRequestThread(ctx, currentSpan);
        }
        return this.createScopeForNonRequestThread(currentSpan);
    }

    private CurrentTraceContext.Scope createScopeForRequestThread(RequestContext ctx, @Nullable TraceContext currentSpan) {
        Attribute<TraceContext> traceContextAttribute = TraceContextUtil.getTraceContextAttribute(ctx);
        final TraceContext previous = (TraceContext)traceContextAttribute.getAndSet((Object)currentSpan);
        if (previous == null) {
            return this.decorateScope(currentSpan, INITIAL_REQUEST_SCOPE);
        }
        class RequestContextTraceContextScope
        implements CurrentTraceContext.Scope {
            RequestContextTraceContextScope() {
            }

            public void close() {
                RequestContextCurrentTraceContext.getTraceContextAttributeOrWarnOnce().set((Object)previous);
            }

            public String toString() {
                return "RequestContextTraceContextScope";
            }
        }
        return this.decorateScope(currentSpan, new RequestContextTraceContextScope());
    }

    private CurrentTraceContext.Scope createScopeForNonRequestThread(@Nullable TraceContext currentSpan) {
        final TraceContext previous = THREAD_LOCAL_CONTEXT.get();
        THREAD_LOCAL_CONTEXT.set(currentSpan);
        class ThreadLocalScope
        implements CurrentTraceContext.Scope {
            ThreadLocalScope() {
            }

            public void close() {
                THREAD_LOCAL_CONTEXT.set(previous);
            }

            public String toString() {
                return "ThreadLocalScope";
            }
        }
        return this.decorateScope(currentSpan, new ThreadLocalScope());
    }

    @Nullable
    private static RequestContext getRequestContextOrWarnOnce() {
        return (RequestContext)RequestContext.mapCurrent(Function.identity(), (Supplier)LogRequestContextWarningOnce.INSTANCE);
    }

    @Nullable
    private static Attribute<TraceContext> getTraceContextAttributeOrWarnOnce() {
        RequestContext ctx = RequestContextCurrentTraceContext.getRequestContextOrWarnOnce();
        if (ctx == null) {
            return null;
        }
        return TraceContextUtil.getTraceContextAttribute(ctx);
    }

    @VisibleForTesting
    static final class PingPongExtra {
        private boolean pong;

        PingPongExtra() {
        }

        static boolean maybeSetPong(TraceContext context) {
            Object extra;
            if (context.extra().size() == 1 && (extra = context.extra().get(0)) instanceof PingPongExtra) {
                ((PingPongExtra)extra).pong = true;
                return true;
            }
            return false;
        }

        boolean isPong() {
            return this.pong;
        }
    }

    private static enum LogRequestContextWarningOnce implements Supplier<RequestContext>
    {
        INSTANCE;


        @Override
        @Nullable
        public RequestContext get() {
            if (Boolean.TRUE.equals(THREAD_NOT_REQUEST_THREAD.get())) {
                return null;
            }
            ClassLoaderHack.loadMe();
            return null;
        }

        private static final class NoRequestContextException
        extends RuntimeException {
            private static final long serialVersionUID = 2804189311774982052L;

            private NoRequestContextException() {
            }
        }

        private static final class ClassLoaderHack {
            private ClassLoaderHack() {
            }

            static void loadMe() {
            }

            static {
                logger.warn("Attempted to propagate trace context, but no request context available. Did you forget to use RequestContext.contextAwareExecutor() or RequestContext.makeContextAware()?", (Throwable)new NoRequestContextException());
            }
        }
    }

    static final class Builder
    extends CurrentTraceContext.Builder {
        Builder() {
        }

        public CurrentTraceContext build() {
            return new RequestContextCurrentTraceContext(this);
        }
    }
}

