/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
    }

    public static String methodToProperty(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw FlexExceptions.wrap("Error parsing property name '%s'.  Didn't start with 'is', 'get' or 'set'.", name);
        }
        if (!name.isEmpty()) {
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH).concat(name.substring(1));
        }
        return name;
    }

    public static String firstCharToLowerCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] chars = string.toCharArray();
            chars[0] = (char)(chars[0] + 32);
            return new String(chars);
        }
        return string;
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] chars = string.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            return new String(chars);
        }
        return string;
    }

    public static String camelToUnderline(String string) {
        if (StringUtil.isBlank(string)) {
            return "";
        }
        int strLen = string.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String underlineToCamel(String string) {
        if (StringUtil.isBlank(string)) {
            return "";
        }
        if (Character.isUpperCase(string.charAt(0))) {
            string = string.toLowerCase();
        }
        int strLen = string.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                if (++i >= strLen) continue;
                sb.append(Character.toUpperCase(string.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String deleteChar(String string, char deleteChar) {
        if (StringUtil.isBlank(string)) {
            return "";
        }
        char[] chars = string.toCharArray();
        StringBuilder sb = new StringBuilder(string.length());
        for (char aChar : chars) {
            if (aChar == deleteChar) continue;
            sb.append(aChar);
        }
        return sb.toString();
    }

    public static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            if (string.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            throw new IllegalArgumentException("strings is null or empty.");
        }
        for (String string : strings) {
            if (!StringUtil.isBlank(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean areNotBlank(String ... strings) {
        return !StringUtil.isAnyBlank(strings);
    }

    public static boolean isNumeric(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        int i = string.length();
        while (--i >= 0) {
            char chr = string.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithAny(String string, String ... prefixes) {
        if (StringUtil.isBlank(string) || prefixes == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(String str, String ... suffixes) {
        if (StringUtil.isBlank(str) || suffixes == null) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String regex, String input) {
        if (null == regex || null == input) {
            return false;
        }
        return Pattern.matches(regex, input);
    }

    public static String join(String delimiter, CharSequence ... elements) {
        if (ArrayUtil.isEmpty(elements)) {
            return "";
        }
        if (elements.length == 1) {
            return String.valueOf(elements[0]);
        }
        return String.join((CharSequence)delimiter, elements);
    }

    public static String join(String delimiter, Collection<? extends CharSequence> elements) {
        if (CollectionUtil.isEmpty(elements)) {
            return "";
        }
        if (elements.size() == 1) {
            return String.valueOf(elements.iterator().next());
        }
        return String.join((CharSequence)delimiter, elements);
    }

    public static <T> String join(String delimiter, Collection<T> objs, Function<T, String> function) {
        if (CollectionUtil.isEmpty(objs)) {
            return "";
        }
        if (objs.size() == 1) {
            T next = objs.iterator().next();
            return String.valueOf(function.apply(next));
        }
        CharSequence[] strings = new String[objs.size()];
        int index = 0;
        for (T obj : objs) {
            strings[index++] = function.apply(obj);
        }
        return String.join((CharSequence)delimiter, strings);
    }

    public static String buildSchemaWithTable(String schema, String tableName) {
        return StringUtil.isNotBlank(schema) ? schema + "." + tableName : tableName;
    }

    public static String[] getSchemaAndTableName(String tableNameWithSchema) {
        String[] stringArray;
        int index = tableNameWithSchema.indexOf(".");
        if (index <= 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = null;
            stringArray = stringArray2;
            stringArray2[1] = tableNameWithSchema.trim();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = tableNameWithSchema.substring(0, index).trim();
            stringArray = stringArray3;
            stringArray3[1] = tableNameWithSchema.substring(index + 1).trim();
        }
        return stringArray;
    }

    public static String[] getTableNameWithAlias(String tableNameWithAlias) {
        String[] stringArray;
        int index = tableNameWithAlias.indexOf(".");
        if (index <= 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = tableNameWithAlias;
            stringArray = stringArray2;
            stringArray2[1] = null;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = tableNameWithAlias.substring(0, index);
            stringArray = stringArray3;
            stringArray3[1] = tableNameWithAlias.substring(index + 1);
        }
        return stringArray;
    }

    public static String tryTrim(String string) {
        return string != null ? string.trim() : null;
    }

    public static String substringAfterLast(String text, String prefix) {
        if (text == null) {
            return null;
        }
        if (prefix == null) {
            return text;
        }
        return text.substring(text.lastIndexOf(prefix) + 1);
    }
}

