/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.tencent.cloud.Policy;
import com.tencent.cloud.RegionCodeFilter;
import com.tencent.cloud.Response;
import com.tencent.cloud.Scope;
import com.tencent.cloud.Statement;
import com.tencent.cloud.cos.util.Jackson;
import com.tencent.cloud.cos.util.Request;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CosStsClient {
    private static final int DEFAULT_DURATION_SECONDS = 1800;
    public static final String STS_DEFAULT_HOST = "sts.tencentcloudapi.com";

    public static Response getCredential(TreeMap<String, Object> config) throws IOException {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        Parameters parameters = new Parameters();
        parameters.parse(config);
        if (parameters.secretId == null) {
            throw new IllegalArgumentException("secretId is null");
        }
        if (parameters.secretKey == null) {
            throw new IllegalArgumentException("secretKey is null");
        }
        String policy = parameters.policy;
        if (policy != null) {
            params.put("Policy", policy);
        } else {
            params.put("Policy", CosStsClient.getPolicy(parameters));
        }
        params.put("DurationSeconds", parameters.duration);
        params.put("Name", "cos-sts-java");
        params.put("Action", "GetFederationToken");
        params.put("Version", "2018-08-13");
        String region = RegionCodeFilter.convert(parameters.region);
        params.put("Region", region);
        if (parameters.secretType != null) {
            params.put("SecretType", parameters.secretType);
        }
        String host = STS_DEFAULT_HOST;
        if (parameters.host != null) {
            host = parameters.host;
        }
        String stsHost = STS_DEFAULT_HOST;
        if (host.startsWith("sts.") && host.endsWith(".tencentcloudapi.com")) {
            stsHost = host;
        }
        String path = "/";
        String result = null;
        JsonNode jsonResult = null;
        try {
            result = Request.send(params, parameters.secretId, parameters.secretKey, "POST", host, stsHost, path);
            jsonResult = Jackson.jsonNodeOf(result);
            JsonNode data = jsonResult.get("Response");
            if (data == null) {
                data = jsonResult;
            }
            Response response = Jackson.fromJsonString(data.toString(), Response.class);
            long expiredTime = data.get("ExpiredTime").asLong();
            response.startTime = expiredTime - (long)parameters.duration;
            if (response.credentials.token != null) {
                response.credentials.sessionToken = response.credentials.token;
                response.credentials.token = null;
            }
            return response;
        }
        catch (Exception e) {
            JsonNode error;
            JsonNode response;
            if (jsonResult != null && (response = jsonResult.get("Response")) != null && (error = response.get("Error")) != null) {
                String message = error.get("Message").asText();
                String code = error.get("Code").asText();
                if ("InvalidParameterValue".equals(code) && message != null && message.contains("Region") && RegionCodeFilter.block(region)) {
                    return CosStsClient.getCredential(config);
                }
            }
            throw new IOException("result = " + result, e);
        }
    }

    public static String getPolicy(List<Scope> scopes) {
        if (scopes == null || scopes.size() == 0) {
            return null;
        }
        Policy policy = new Policy();
        policy.setVersion("2.0");
        for (Scope scope : scopes) {
            Statement statement = new Statement();
            statement.setEffect(scope.getEffect());
            statement.addAction(scope.getAction());
            statement.addResource(scope.getResource());
            policy.addStatement(statement);
        }
        return Jackson.toJsonPrettyString(policy);
    }

    static String getPolicy(Parameters parameters) {
        if (parameters.bucket == null) {
            throw new IllegalArgumentException("bucket == null");
        }
        if (parameters.allowPrefixes == null) {
            throw new IllegalArgumentException("allowPrefixes == null");
        }
        if (parameters.region == null) {
            throw new IllegalArgumentException("region == null");
        }
        Statement statement = new Statement();
        statement.setEffect("allow");
        for (String action : parameters.allowActions) {
            statement.addAction(action);
        }
        String bucket = parameters.bucket;
        String region = parameters.region;
        int lastSplit = bucket.lastIndexOf("-");
        String appId = bucket.substring(lastSplit + 1);
        for (String prefix : parameters.allowPrefixes) {
            String p = prefix;
            if (!p.startsWith("/")) {
                p = "/" + p;
            }
            String resource = String.format("qcs::cos:%s:uid/%s:%s%s", region, appId, bucket, p);
            statement.addResource(resource);
        }
        Policy policy = new Policy();
        policy.setVersion("2.0");
        policy.addStatement(statement);
        return Jackson.toJsonPrettyString(policy);
    }

    static class Parameters {
        String secretId;
        String secretKey;
        int duration = 1800;
        String bucket;
        String region;
        String[] allowPrefixes;
        String[] allowActions;
        String policy;
        Integer secretType;
        String host;

        Parameters() {
        }

        public void parse(Map<String, Object> config) {
            if (config == null) {
                throw new NullPointerException("config == null");
            }
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                String key = entry.getKey();
                if ("SecretId".equalsIgnoreCase(key)) {
                    this.secretId = (String)entry.getValue();
                    continue;
                }
                if ("SecretKey".equalsIgnoreCase(key)) {
                    this.secretKey = (String)entry.getValue();
                    continue;
                }
                if ("durationSeconds".equalsIgnoreCase(key)) {
                    this.duration = (Integer)entry.getValue();
                    continue;
                }
                if ("bucket".equalsIgnoreCase(key)) {
                    this.bucket = (String)entry.getValue();
                    continue;
                }
                if ("region".equalsIgnoreCase(key)) {
                    this.region = (String)entry.getValue();
                    continue;
                }
                if ("allowPrefix".equalsIgnoreCase(key)) {
                    this.allowPrefixes = new String[]{(String)entry.getValue()};
                    continue;
                }
                if ("allowPrefixes".equalsIgnoreCase(key)) {
                    this.allowPrefixes = (String[])entry.getValue();
                    continue;
                }
                if ("policy".equalsIgnoreCase(key)) {
                    this.policy = (String)entry.getValue();
                    continue;
                }
                if ("allowActions".equalsIgnoreCase(key)) {
                    this.allowActions = (String[])entry.getValue();
                    continue;
                }
                if ("secretType".equalsIgnoreCase(key)) {
                    this.secretType = (Integer)entry.getValue();
                    continue;
                }
                if (!"host".equalsIgnoreCase(key)) continue;
                this.host = (String)entry.getValue();
            }
        }
    }
}

