/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.google.common.base.MoreObjects;
import com.spotify.docker.client.messages.Ipam;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NetworkConfig {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="IPAM")
    private Ipam ipam;
    @JsonProperty(value="Options")
    private Map<String, String> options;
    @JsonProperty(value="CheckDuplicate")
    private boolean checkDuplicate;

    private NetworkConfig(Builder builder) {
        this.name = builder.name;
        this.options = builder.options;
        this.driver = builder.driver;
        this.ipam = builder.ipam;
        this.checkDuplicate = builder.checkDuplicate;
    }

    public String name() {
        return this.name;
    }

    public String driver() {
        return this.driver;
    }

    public Ipam ipam() {
        return this.ipam;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public boolean checkDuplicate() {
        return this.checkDuplicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkConfig that = (NetworkConfig)o;
        return Objects.equals(this.checkDuplicate, that.checkDuplicate) && Objects.equals(this.name, that.name) && Objects.equals(this.driver, that.driver) && Objects.equals(this.ipam, that.ipam) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.driver, this.ipam, this.options, this.checkDuplicate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("driver", (Object)this.driver).add("options", this.options).add("checkDuplicate", this.checkDuplicate).add("ipam", (Object)this.ipam).toString();
    }

    public static class Builder {
        private String name;
        private Map<String, String> options = new HashMap<String, String>();
        private String driver;
        private Ipam ipam;
        public boolean checkDuplicate;

        private Builder() {
        }

        public Builder name(String name) {
            if (name != null && !name.isEmpty()) {
                this.name = name;
            }
            return this;
        }

        public Builder option(String key, String value) {
            if (key != null && !key.isEmpty()) {
                this.options.put(key, value);
            }
            return this;
        }

        public Builder ipam(Ipam ipam) {
            if (ipam != null) {
                this.ipam = ipam;
            }
            return this;
        }

        public Builder driver(String driver) {
            if (driver != null && !driver.isEmpty()) {
                this.driver = driver;
            }
            return this;
        }

        public Builder checkDuplicate(boolean check) {
            this.checkDuplicate = check;
            return this;
        }

        public NetworkConfig build() {
            return new NetworkConfig(this);
        }
    }
}

