/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u009f\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001+\u0018\u00002\u00020\u0001:\u0002bcB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010.\u001a\u00020/2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u00100\u001a\u00020/H\u0002J\b\u00101\u001a\u00020/H\u0016J\b\u00102\u001a\u00020\u0000H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020/2\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0007J\b\u0010=\u001a\u00020>H\u0016J\u0015\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bAJ\r\u0010B\u001a\u00020>H\u0000\u00a2\u0006\u0002\bCJ\u0015\u0010D\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ\b\u0010H\u001a\u00020\u0007H\u0016J\b\u0010I\u001a\u00020\u0007H\u0016J)\u0010J\u001a\u0002HK\"\n\b\u0000\u0010K*\u0004\u0018\u00010L2\u0006\u0010M\u001a\u0002HK2\u0006\u0010N\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010OJ;\u0010P\u001a\u0002HK\"\n\b\u0000\u0010K*\u0004\u0018\u00010L2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u00072\u0006\u0010M\u001a\u0002HKH\u0000\u00a2\u0006\u0004\bS\u0010TJ\u0019\u0010'\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010LH\u0000\u00a2\u0006\u0002\bUJ\r\u0010V\u001a\u00020WH\u0000\u00a2\u0006\u0002\bXJ\u000f\u0010Y\u001a\u0004\u0018\u00010ZH\u0000\u00a2\u0006\u0002\b[J\b\u0010;\u001a\u00020\u0005H\u0016J\u0006\u0010\\\u001a\u00020\u0007J\b\u0010*\u001a\u00020]H\u0016J\u0006\u0010-\u001a\u00020/J!\u0010^\u001a\u0002HK\"\n\b\u0000\u0010K*\u0004\u0018\u00010L2\u0006\u0010_\u001a\u0002HKH\u0002\u00a2\u0006\u0002\u0010`J\b\u0010a\u001a\u00020WH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010$\u001a\u0004\u0018\u00010\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u001b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0010\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,R\u000e\u0010-\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "callStackTrace", "", "canceled", "getClient", "()Lokhttp3/OkHttpClient;", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "setConnection", "(Lokhttp3/internal/connection/RealConnection;)V", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "exchangeRequestDone", "exchangeResponseDone", "executed", "getForWebSocket", "()Z", "<set-?>", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "noMoreExchanges", "getOriginalRequest", "()Lokhttp3/Request;", "timeout", "okhttp3/internal/connection/RealCall$timeout$1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callStart", "cancel", "clone", "createAddress", "Lokhttp3/Address;", "url", "Lokhttp3/HttpUrl;", "enqueue", "responseCallback", "Lokhttp3/Callback;", "enterNetworkInterceptorExchange", "request", "newExchangeFinder", "execute", "Lokhttp3/Response;", "exitNetworkInterceptorExchange", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "getResponseWithInterceptorChain", "getResponseWithInterceptorChain$okhttp", "initExchange", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "initExchange$okhttp", "isCanceled", "isExecuted", "maybeReleaseConnection", "E", "Ljava/io/IOException;", "e", "force", "(Ljava/io/IOException;Z)Ljava/io/IOException;", "messageDone", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "noMoreExchanges$okhttp", "redactedUrl", "", "redactedUrl$okhttp", "releaseConnectionNoEvents", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "retryAfterFailure", "Lokio/AsyncTimeout;", "timeoutExit", "cause", "(Ljava/io/IOException;)Ljava/io/IOException;", "toLoggableString", "AsyncCall", "CallReference", "okhttp"})
public final class RealCall
implements Call {
    private final RealConnectionPool connectionPool;
    @NotNull
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    @Nullable
    private RealConnection connection;
    private Exchange exchange;
    private boolean exchangeRequestDone;
    private boolean exchangeResponseDone;
    private boolean canceled;
    private boolean timeoutEarlyExit;
    private boolean noMoreExchanges;
    private boolean executed;
    @Nullable
    private Exchange interceptorScopedExchange;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final Request originalRequest;
    private final boolean forWebSocket;

    @NotNull
    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    @Nullable
    public final RealConnection getConnection() {
        return this.connection;
    }

    public final void setConnection(@Nullable RealConnection realConnection) {
        this.connection = realConnection;
    }

    @Nullable
    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    @NotNull
    public AsyncTimeout timeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    @NotNull
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Exchange exchangeToCancel = null;
        Object connectionToCancel = null;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            exchangeToCancel = this.exchange;
            Object object = this.exchangeFinder;
            if (object == null || (object = ((ExchangeFinder)object).connectingConnection()) == null) {
                object = this.connection;
            }
            connectionToCancel = object;
            Unit unit = Unit.INSTANCE;
        }
        Exchange exchange = exchangeToCancel;
        if (exchange != null) {
            exchange.cancel();
        } else {
            Object object = connectionToCancel;
            if (object != null) {
                ((RealConnection)object).cancel();
            }
        }
        this.eventListener.canceled(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = this.canceled;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response execute() {
        Object object = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            boolean bl4 = !this.executed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Already Executed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.executed = true;
            Unit unit = Unit.INSTANCE;
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            object = this.getResponseWithInterceptorChain$okhttp();
            return object;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(@NotNull Callback responseCallback) {
        Intrinsics.checkParameterIsNotNull((Object)responseCallback, (String)"responseCallback");
        RealCall realCall = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realCall) {
            boolean bl3 = false;
            boolean bl4 = !this.executed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Already Executed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.executed = true;
            Unit unit = Unit.INSTANCE;
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(responseCallback));
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        boolean bl = false;
        List interceptors = new ArrayList();
        Collection collection = interceptors;
        Object object = this.client.interceptors();
        boolean bl2 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        collection = interceptors;
        object = new RetryAndFollowUpInterceptor(this.client);
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = new BridgeInterceptor(this.client.cookieJar());
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = new CacheInterceptor(this.client.cache());
        bl2 = false;
        collection.add(object);
        collection = interceptors;
        object = ConnectInterceptor.INSTANCE;
        bl2 = false;
        collection.add(object);
        if (!this.forWebSocket) {
            collection = interceptors;
            object = this.client.networkInterceptors();
            bl2 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        collection = interceptors;
        object = new CallServerInterceptor(this.forWebSocket);
        bl2 = false;
        collection.add(object);
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            Response response2 = chain.proceed(this.originalRequest);
            if (this.isCanceled()) {
                Util.closeQuietly(response2);
                throw (Throwable)new IOException("Canceled");
            }
            response = response2;
        }
        catch (IOException e) {
            try {
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp(e);
                if (iOException == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                if (!calledNoMoreExchanges) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        this.noMoreExchanges$okhttp(null);
        return response;
    }

    public final void enterNetworkInterceptorExchange(@NotNull Request request, boolean newExchangeFinder) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        boolean bl = this.interceptorScopedExchange == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.exchange == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "cannot make a new request because the previous response is still open: please call response.close()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (newExchangeFinder) {
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, this.createAddress(request.url()), this, this.eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Exchange initExchange$okhttp(@NotNull RealInterceptorChain chain) {
        Exchange result;
        Object object;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realConnectionPool) {
            boolean bl4 = false;
            bl = !this.noMoreExchanges;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "released";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = this.exchange == null;
            bl5 = false;
            bl6 = false;
            bl6 = false;
            boolean bl8 = false;
            if (!bl) {
                boolean bl9 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            object = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        if (exchangeFinder == null) {
            Intrinsics.throwNpe();
        }
        ExchangeCodec codec = exchangeFinder.find(this.client, chain);
        ExchangeFinder exchangeFinder2 = this.exchangeFinder;
        if (exchangeFinder2 == null) {
            Intrinsics.throwNpe();
        }
        this.interceptorScopedExchange = result = new Exchange(this, this.eventListener, exchangeFinder2, codec);
        object = this.connectionPool;
        boolean bl10 = false;
        bl = false;
        synchronized (object) {
            boolean bl11 = false;
            this.exchange = result;
            this.exchangeRequestDone = false;
            this.exchangeResponseDone = false;
            Exchange exchange = result;
            return exchange;
        }
    }

    public final void acquireConnectionNoEvents(@NotNull RealConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        RealConnectionPool $this$assertThreadHoldsLock$iv = this.connectionPool;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        boolean bl = this.connection == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.connection = connection;
        connection.getCalls().add(new CallReference(this, this.callStackTrace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E messageDone$okhttp(@NotNull Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        E result = e;
        boolean exchangeDone = false;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            block11: {
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)exchange, (Object)this.exchange) ^ true)) break block11;
                E e2 = result;
                return e2;
            }
            boolean changed = false;
            if (requestDone) {
                if (!this.exchangeRequestDone) {
                    changed = true;
                }
                this.exchangeRequestDone = true;
            }
            if (responseDone) {
                if (!this.exchangeResponseDone) {
                    changed = true;
                }
                this.exchangeResponseDone = true;
            }
            if (this.exchangeRequestDone && this.exchangeResponseDone && changed) {
                exchangeDone = true;
                Exchange exchange2 = this.exchange;
                if (exchange2 == null) {
                    Intrinsics.throwNpe();
                }
                RealConnection realConnection = exchange2.getConnection$okhttp();
                int n = realConnection.getSuccessCount$okhttp();
                realConnection.setSuccessCount$okhttp(n + 1);
                this.exchange = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (exchangeDone) {
            result = this.maybeReleaseConnection(result, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IOException noMoreExchanges$okhttp(@Nullable IOException e) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            this.noMoreExchanges = true;
            Unit unit = Unit.INSTANCE;
        }
        return this.maybeReleaseConnection(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E maybeReleaseConnection(E e, boolean force) {
        E result = e;
        Socket socket = null;
        Ref.ObjectRef releasedConnection = new Ref.ObjectRef();
        boolean callEnd = false;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = !force || this.exchange == null;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "cannot release connection while it is in use";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            releasedConnection.element = this.connection;
            Socket socket2 = socket = this.connection != null && this.exchange == null && (force || this.noMoreExchanges) ? this.releaseConnectionNoEvents$okhttp() : null;
            if (this.connection != null) {
                releasedConnection.element = null;
            }
            callEnd = this.noMoreExchanges && this.exchange == null;
            Unit unit = Unit.INSTANCE;
        }
        Socket socket3 = socket;
        if (socket3 != null) {
            Util.closeQuietly(socket3);
        }
        if ((Connection)releasedConnection.element != null) {
            Call call = this;
            Connection connection = (Connection)releasedConnection.element;
            if (connection == null) {
                Intrinsics.throwNpe();
            }
            this.eventListener.connectionReleased(call, connection);
        }
        if (callEnd) {
            boolean callFailed = result != null;
            result = this.timeoutExit(result);
            if (callFailed) {
                Call call = this;
                E e2 = result;
                if (e2 == null) {
                    Intrinsics.throwNpe();
                }
                this.eventListener.callFailed(call, e2);
            } else {
                this.eventListener.callEnd(this);
            }
        }
        return result;
    }

    @Nullable
    public final Socket releaseConnectionNoEvents$okhttp() {
        RealConnection released;
        int n;
        block8: {
            RealConnectionPool $this$assertThreadHoldsLock$iv = this.connectionPool;
            boolean $i$f$assertThreadHoldsLock = false;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
            }
            RealConnection realConnection = this.connection;
            if (realConnection == null) {
                Intrinsics.throwNpe();
            }
            List<Reference<RealCall>> $this$indexOfFirst$iv = realConnection.getCalls();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Reference<RealCall>> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Reference<RealCall> item$iv;
                Reference<RealCall> it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.get(), (Object)this)) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        boolean $this$indexOfFirst$iv = index != -1;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (!$this$indexOfFirst$iv) {
            boolean bl4 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RealConnection realConnection = released = this.connection;
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        realConnection.getCalls().remove(index);
        this.connection = null;
        if (released.getCalls().isEmpty()) {
            released.setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle(released)) {
                return released.socket();
            }
        }
        return null;
    }

    private final <E extends IOException> E timeoutExit(E cause) {
        if (this.timeoutEarlyExit) {
            return cause;
        }
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return (E)e;
    }

    public final void timeoutEarlyExit() {
        boolean bl = !this.timeoutEarlyExit;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange) {
        boolean bl = !this.noMoreExchanges;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "released";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (closeExchange) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
            bl = this.exchange == null;
            bl2 = false;
            bl3 = false;
            bl3 = false;
            boolean bl5 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        this.interceptorScopedExchange = null;
    }

    private final Address createAddress(HttpUrl url) {
        SSLSocketFactory sslSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (url.isHttps()) {
            sslSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(url.host(), url.port(), this.client.dns(), this.client.socketFactory(), sslSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        if (exchangeFinder == null) {
            Intrinsics.throwNpe();
        }
        return exchangeFinder.retryAfterFailure();
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    @NotNull
    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public RealCall(@NotNull OkHttpClient client, @NotNull Request originalRequest, boolean forWebSocket) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)originalRequest, (String)"originalRequest");
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;

            protected void timedOut() {
                this.this$0.cancel();
            }
            {
                this.this$0 = $outer;
            }
        };
        RealCall realCall = this;
        boolean bl = false;
        boolean bl2 = false;
        AsyncTimeout $this$apply = asyncTimeout;
        boolean bl3 = false;
        $this$apply.timeout((long)this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        AsyncTimeout asyncTimeout2 = asyncTimeout;
        realCall.timeout = asyncTimeout2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "call", "Lokhttp3/internal/connection/RealCall;", "getCall", "()Lokhttp3/internal/connection/RealCall;", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "callsPerHost", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host", "", "getHost", "()Ljava/lang/String;", "request", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
    public final class AsyncCall
    implements Runnable {
        @NotNull
        private volatile AtomicInteger callsPerHost;
        private final Callback responseCallback;

        @NotNull
        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        public final void reuseCallsPerHostFrom(@NotNull AsyncCall other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            this.callsPerHost = other.callsPerHost;
        }

        @NotNull
        public final String getHost() {
            return RealCall.this.getOriginalRequest().url().host();
        }

        @NotNull
        public final Request getRequest() {
            return RealCall.this.getOriginalRequest();
        }

        @NotNull
        public final RealCall getCall() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeOn(@NotNull ExecutorService executorService) {
            Intrinsics.checkParameterIsNotNull((Object)executorService, (String)"executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = RealCall.this.getClient().dispatcher();
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                StringBuilder stringBuilder = new StringBuilder().append("Thread ");
                Thread thread = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
            }
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                ioException.initCause(e);
                RealCall.this.noMoreExchanges$okhttp(ioException);
                this.responseCallback.onFailure(RealCall.this, ioException);
            }
            finally {
                RealCall.this.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread currentThread$iv;
            String name$iv = "OkHttp " + RealCall.this.redactedUrl$okhttp();
            boolean $i$f$threadName = false;
            Thread thread = currentThread$iv = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
            String oldName$iv = thread.getName();
            currentThread$iv.setName(name$iv);
            try {
                boolean bl = false;
                boolean signalledCallback = false;
                RealCall.this.timeout.enter();
                try {
                    Response response = RealCall.this.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get().log("Callback failure for " + RealCall.this.toLoggableString(), 4, e);
                    } else {
                        this.responseCallback.onFailure(RealCall.this, e);
                    }
                }
                catch (Throwable t) {
                    RealCall.this.cancel();
                    if (!signalledCallback) {
                        IOException canceledException = new IOException("canceled due to " + t);
                        canceledException.addSuppressed(t);
                        this.responseCallback.onFailure(RealCall.this, canceledException);
                    }
                    throw t;
                }
                finally {
                    RealCall.this.getClient().dispatcher().finished$okhttp(this);
                }
            }
            finally {
                currentThread$iv.setName(oldName$iv);
            }
        }

        public AsyncCall(Callback responseCallback) {
            Intrinsics.checkParameterIsNotNull((Object)responseCallback, (String)"responseCallback");
            this.responseCallback = responseCallback;
            this.callsPerHost = new AtomicInteger(0);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RealCall$CallReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/RealCall;", "referent", "callStackTrace", "", "(Lokhttp3/internal/connection/RealCall;Ljava/lang/Object;)V", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class CallReference
    extends WeakReference<RealCall> {
        @Nullable
        private final Object callStackTrace;

        @Nullable
        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }

        public CallReference(@NotNull RealCall referent, @Nullable Object callStackTrace) {
            Intrinsics.checkParameterIsNotNull((Object)referent, (String)"referent");
            super(referent);
            this.callStackTrace = callStackTrace;
        }
    }
}

