

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EnumConstantElement extends EnumConstantElement {

  private final Location location;

  private final String name;

  private final int tag;

  private final String documentation;

  private final ImmutableList<OptionElement> options;

  private AutoValue_EnumConstantElement(
      Location location,
      String name,
      int tag,
      String documentation,
      ImmutableList<OptionElement> options) {
    this.location = location;
    this.name = name;
    this.tag = tag;
    this.documentation = documentation;
    this.options = options;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public int tag() {
    return tag;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public String toString() {
    return "EnumConstantElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "tag=" + tag + ", "
         + "documentation=" + documentation + ", "
         + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EnumConstantElement) {
      EnumConstantElement that = (EnumConstantElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.tag == that.tag())
           && (this.documentation.equals(that.documentation()))
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= tag;
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements EnumConstantElement.Builder {
    private Location location;
    private String name;
    private Integer tag;
    private String documentation;
    private ImmutableList<OptionElement> options;
    Builder() {
    }
    @Override
    public EnumConstantElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public EnumConstantElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public EnumConstantElement.Builder tag(int tag) {
      this.tag = tag;
      return this;
    }
    @Override
    public EnumConstantElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public EnumConstantElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public EnumConstantElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.tag == null) {
        missing += " tag";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EnumConstantElement(
          this.location,
          this.name,
          this.tag,
          this.documentation,
          this.options);
    }
  }

}
