

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EnumElement extends EnumElement {

  private final Location location;

  private final String name;

  private final String documentation;

  private final ImmutableList<OptionElement> options;

  private final ImmutableList<EnumConstantElement> constants;

  private AutoValue_EnumElement(
      Location location,
      String name,
      String documentation,
      ImmutableList<OptionElement> options,
      ImmutableList<EnumConstantElement> constants) {
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.options = options;
    this.constants = constants;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public ImmutableList<EnumConstantElement> constants() {
    return constants;
  }

  @Override
  public String toString() {
    return "EnumElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "options=" + options + ", "
         + "constants=" + constants
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EnumElement) {
      EnumElement that = (EnumElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.options.equals(that.options()))
           && (this.constants.equals(that.constants()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    h$ *= 1000003;
    h$ ^= constants.hashCode();
    return h$;
  }

  static final class Builder implements EnumElement.Builder {
    private Location location;
    private String name;
    private String documentation;
    private ImmutableList<OptionElement> options;
    private ImmutableList<EnumConstantElement> constants;
    Builder() {
    }
    @Override
    public EnumElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public EnumElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public EnumElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public EnumElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public EnumElement.Builder constants(ImmutableList<EnumConstantElement> constants) {
      if (constants == null) {
        throw new NullPointerException("Null constants");
      }
      this.constants = constants;
      return this;
    }
    @Override
    public EnumElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (this.constants == null) {
        missing += " constants";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EnumElement(
          this.location,
          this.name,
          this.documentation,
          this.options,
          this.constants);
    }
  }

}
