

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessageElement extends MessageElement {

  private final Location location;

  private final String name;

  private final String documentation;

  private final ImmutableList<TypeElement> nestedTypes;

  private final ImmutableList<OptionElement> options;

  private final ImmutableList<ReservedElement> reserveds;

  private final ImmutableList<FieldElement> fields;

  private final ImmutableList<OneOfElement> oneOfs;

  private final ImmutableList<ExtensionsElement> extensions;

  private final ImmutableList<GroupElement> groups;

  private AutoValue_MessageElement(
      Location location,
      String name,
      String documentation,
      ImmutableList<TypeElement> nestedTypes,
      ImmutableList<OptionElement> options,
      ImmutableList<ReservedElement> reserveds,
      ImmutableList<FieldElement> fields,
      ImmutableList<OneOfElement> oneOfs,
      ImmutableList<ExtensionsElement> extensions,
      ImmutableList<GroupElement> groups) {
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.nestedTypes = nestedTypes;
    this.options = options;
    this.reserveds = reserveds;
    this.fields = fields;
    this.oneOfs = oneOfs;
    this.extensions = extensions;
    this.groups = groups;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<TypeElement> nestedTypes() {
    return nestedTypes;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public ImmutableList<ReservedElement> reserveds() {
    return reserveds;
  }

  @Override
  public ImmutableList<FieldElement> fields() {
    return fields;
  }

  @Override
  public ImmutableList<OneOfElement> oneOfs() {
    return oneOfs;
  }

  @Override
  public ImmutableList<ExtensionsElement> extensions() {
    return extensions;
  }

  @Override
  public ImmutableList<GroupElement> groups() {
    return groups;
  }

  @Override
  public String toString() {
    return "MessageElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "nestedTypes=" + nestedTypes + ", "
         + "options=" + options + ", "
         + "reserveds=" + reserveds + ", "
         + "fields=" + fields + ", "
         + "oneOfs=" + oneOfs + ", "
         + "extensions=" + extensions + ", "
         + "groups=" + groups
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessageElement) {
      MessageElement that = (MessageElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.nestedTypes.equals(that.nestedTypes()))
           && (this.options.equals(that.options()))
           && (this.reserveds.equals(that.reserveds()))
           && (this.fields.equals(that.fields()))
           && (this.oneOfs.equals(that.oneOfs()))
           && (this.extensions.equals(that.extensions()))
           && (this.groups.equals(that.groups()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= nestedTypes.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    h$ *= 1000003;
    h$ ^= reserveds.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= oneOfs.hashCode();
    h$ *= 1000003;
    h$ ^= extensions.hashCode();
    h$ *= 1000003;
    h$ ^= groups.hashCode();
    return h$;
  }

  static final class Builder implements MessageElement.Builder {
    private Location location;
    private String name;
    private String documentation;
    private ImmutableList<TypeElement> nestedTypes;
    private ImmutableList<OptionElement> options;
    private ImmutableList<ReservedElement> reserveds;
    private ImmutableList<FieldElement> fields;
    private ImmutableList<OneOfElement> oneOfs;
    private ImmutableList<ExtensionsElement> extensions;
    private ImmutableList<GroupElement> groups;
    Builder() {
    }
    @Override
    public MessageElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public MessageElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public MessageElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public MessageElement.Builder nestedTypes(ImmutableList<TypeElement> nestedTypes) {
      if (nestedTypes == null) {
        throw new NullPointerException("Null nestedTypes");
      }
      this.nestedTypes = nestedTypes;
      return this;
    }
    @Override
    public MessageElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public MessageElement.Builder reserveds(ImmutableList<ReservedElement> reserveds) {
      if (reserveds == null) {
        throw new NullPointerException("Null reserveds");
      }
      this.reserveds = reserveds;
      return this;
    }
    @Override
    public MessageElement.Builder fields(ImmutableList<FieldElement> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public MessageElement.Builder oneOfs(ImmutableList<OneOfElement> oneOfs) {
      if (oneOfs == null) {
        throw new NullPointerException("Null oneOfs");
      }
      this.oneOfs = oneOfs;
      return this;
    }
    @Override
    public MessageElement.Builder extensions(ImmutableList<ExtensionsElement> extensions) {
      if (extensions == null) {
        throw new NullPointerException("Null extensions");
      }
      this.extensions = extensions;
      return this;
    }
    @Override
    public MessageElement.Builder groups(ImmutableList<GroupElement> groups) {
      if (groups == null) {
        throw new NullPointerException("Null groups");
      }
      this.groups = groups;
      return this;
    }
    @Override
    public MessageElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.nestedTypes == null) {
        missing += " nestedTypes";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (this.reserveds == null) {
        missing += " reserveds";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (this.oneOfs == null) {
        missing += " oneOfs";
      }
      if (this.extensions == null) {
        missing += " extensions";
      }
      if (this.groups == null) {
        missing += " groups";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessageElement(
          this.location,
          this.name,
          this.documentation,
          this.nestedTypes,
          this.options,
          this.reserveds,
          this.fields,
          this.oneOfs,
          this.extensions,
          this.groups);
    }
  }

}
